/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class CallableStatementCreatorFactory {
    private final String callString;
    private final List declaredParameters;
    private int resultSetType = 1003;
    private boolean updatableResults = false;
    private NativeJdbcExtractor nativeJdbcExtractor;

    public CallableStatementCreatorFactory(String callString) {
        this.callString = callString;
        this.declaredParameters = new LinkedList();
    }

    public CallableStatementCreatorFactory(String callString, List declaredParameters) {
        this.callString = callString;
        this.declaredParameters = declaredParameters;
    }

    public void addParameter(SqlParameter param) {
        this.declaredParameters.add(param);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public CallableStatementCreator newCallableStatementCreator(Map inParams) {
        return new CallableStatementCreatorImpl(inParams != null ? inParams : new HashMap());
    }

    public CallableStatementCreator newCallableStatementCreator(ParameterMapper inParamMapper) {
        return new CallableStatementCreatorImpl(inParamMapper);
    }

    private class CallableStatementCreatorImpl
    implements CallableStatementCreator,
    SqlProvider,
    ParameterDisposer {
        private ParameterMapper inParameterMapper;
        private Map inParameters;

        public CallableStatementCreatorImpl(ParameterMapper inParamMapper) {
            this.inParameterMapper = inParamMapper;
        }

        public CallableStatementCreatorImpl(Map inParams) {
            this.inParameters = inParams;
        }

        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            if (this.inParameterMapper != null) {
                this.inParameters = this.inParameterMapper.createMap(con);
            } else if (this.inParameters == null) {
                throw new InvalidDataAccessApiUsageException("A ParameterMapper or a Map of parameters must be provided");
            }
            CallableStatement cs = null;
            cs = CallableStatementCreatorFactory.this.resultSetType == 1003 && !CallableStatementCreatorFactory.this.updatableResults ? con.prepareCall(CallableStatementCreatorFactory.this.callString) : con.prepareCall(CallableStatementCreatorFactory.this.callString, CallableStatementCreatorFactory.this.resultSetType, CallableStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            CallableStatement csToUse = cs;
            if (CallableStatementCreatorFactory.this.nativeJdbcExtractor != null) {
                csToUse = CallableStatementCreatorFactory.this.nativeJdbcExtractor.getNativeCallableStatement(cs);
            }
            int sqlColIndx = 1;
            for (int i = 0; i < CallableStatementCreatorFactory.this.declaredParameters.size(); ++i) {
                SqlParameter declaredParameter = (SqlParameter)CallableStatementCreatorFactory.this.declaredParameters.get(i);
                if (!this.inParameters.containsKey(declaredParameter.getName()) && !(declaredParameter instanceof ResultSetSupportingSqlParameter)) {
                    throw new InvalidDataAccessApiUsageException("Required input parameter '" + declaredParameter.getName() + "' is missing");
                }
                Object inValue = this.inParameters.get(declaredParameter.getName());
                if (!(declaredParameter instanceof ResultSetSupportingSqlParameter)) {
                    StatementCreatorUtils.setParameterValue((PreparedStatement)csToUse, sqlColIndx, declaredParameter, inValue);
                } else if (declaredParameter instanceof SqlOutParameter) {
                    if (declaredParameter.getTypeName() != null) {
                        cs.registerOutParameter(sqlColIndx, declaredParameter.getSqlType(), declaredParameter.getTypeName());
                    } else {
                        cs.registerOutParameter(sqlColIndx, declaredParameter.getSqlType());
                    }
                    if (((SqlOutParameter)declaredParameter).isInputValueProvided() || inValue != null) {
                        StatementCreatorUtils.setParameterValue((PreparedStatement)csToUse, sqlColIndx, declaredParameter, inValue);
                    }
                }
                if (declaredParameter instanceof SqlReturnResultSet) continue;
                ++sqlColIndx;
            }
            return cs;
        }

        public String getSql() {
            return CallableStatementCreatorFactory.this.callString;
        }

        public void cleanupParameters() {
            if (this.inParameters != null) {
                StatementCreatorUtils.cleanupParameters(this.inParameters.values());
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("CallableStatementCreatorFactory.CallableStatementCreatorImpl: sql=[");
            buf.append(CallableStatementCreatorFactory.this.callString).append("]; parameters=").append(this.inParameters);
            return buf.toString();
        }
    }
}

