/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.controlbreak;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakDef;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakRowObject;
import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBreakChunk
extends Chunk {
    public static final Object END_MARK = new Object();
    public static final Object CHUNK_BREAK_MARK = new Object();
    private final List<ControlBreakDefItem> controlBreakDefItemList;
    private final ControlBreakDefItem chunkControlBreakDefItem;
    private final List<ControlBreakDefItem> transChunkControlBreakDefItemList;
    private boolean chunkControlBreak = false;
    private Map<String, Object> chunkControlBreakMap = null;
    private Map<String, Object> chunkNextData = null;
    private Map<String, Object> controlBreakMap = null;
    private Map<String, Object> nextData = null;
    private List<List<String>> transChunkControlBreakKeyList = null;
    private LinkedHashMap<String, Object> transNextData = null;
    private boolean endChunk = false;
    private FastHashMap methodMap = null;

    public ControlBreakChunk(JobContext jobContext, ControlBreakDef controlBreakDef, int chunkSize) {
        super(chunkSize, jobContext);
        this.controlBreakDefItemList = controlBreakDef.getControlBreakDefItemList();
        this.chunkControlBreakDefItem = controlBreakDef.getChunkControlBreakDefItem();
        this.transChunkControlBreakDefItemList = controlBreakDef.getTransChunkControlBreakDefItemList();
        this.transChunkControlBreakKeyList = new ArrayList<List<String>>(this.transChunkControlBreakDefItemList.size());
        this.chunkNextData = new LinkedHashMap<String, Object>(this.chunkControlBreakDefItem.getBreakKey().size());
        this.transNextData = new LinkedHashMap(this.chunkNextData.size());
    }

    public ControlBreakChunk(JobContext jobContext, ControlBreakDef controlBreakDef, int chunkSize, Map<String, Object> nextData, Map<String, Object> chunkNextData) {
        super(chunkSize, jobContext);
        this.controlBreakDefItemList = controlBreakDef.getControlBreakDefItemList();
        this.chunkControlBreakDefItem = controlBreakDef.getChunkControlBreakDefItem();
        this.transChunkControlBreakDefItemList = controlBreakDef.getTransChunkControlBreakDefItemList();
        this.transChunkControlBreakKeyList = new ArrayList<List<String>>(this.transChunkControlBreakDefItemList.size());
        this.nextData = nextData;
        this.controlBreakMap = nextData;
        this.chunkControlBreakMap = chunkNextData;
        this.chunkNextData = new LinkedHashMap<String, Object>(this.chunkControlBreakDefItem.getBreakKey().size());
        this.transNextData = new LinkedHashMap(chunkNextData.size());
    }

    public ControlBreakRowObject setNext(Object next) {
        this.controlBreakMap = this.nextData;
        this.transChunkControlBreakKeyList.clear();
        this.chunkNextData.clear();
        ArrayList<List<String>> controlBreakKeyList = new ArrayList<List<String>>(this.controlBreakDefItemList.size());
        this.transNextData.clear();
        if (this.chunkControlBreakDefItem.getBreakKey().size() > 0) {
            for (String propertyName : this.chunkControlBreakDefItem.getBreakKey()) {
                Object value = this.getBreakKeyValue(next, propertyName);
                this.chunkNextData.put(propertyName, value);
                if (this.chunkControlBreakMap == null || value == null || value.equals(this.chunkControlBreakMap.get(propertyName))) continue;
                this.chunkControlBreak = true;
                this.transNextData.put(propertyName, value);
            }
        }
        if (this.chunkControlBreak) {
            this.checkTransChunkControlBreak(this.transNextData.keySet());
        }
        if (this.chunkControlBreakMap == null) {
            this.chunkControlBreakMap = this.chunkNextData;
            this.chunkNextData = new LinkedHashMap<String, Object>(this.chunkControlBreakDefItem.getBreakKey().size());
        }
        if (this.controlBreakDefItemList.size() > 0) {
            this.nextData = new LinkedHashMap<String, Object>(this.controlBreakDefItemList.size());
            for (ControlBreakDefItem controlBreakDefItem : this.controlBreakDefItemList) {
                boolean controlBreak = false;
                for (String propertyName : controlBreakDefItem.getBreakKey()) {
                    Object value = this.getBreakKeyValue(next, propertyName);
                    this.nextData.put(propertyName, value);
                    if (controlBreak || this.controlBreakMap == null || value == null || value.equals(this.controlBreakMap.get(propertyName))) continue;
                    controlBreak = true;
                }
                if (!controlBreak) continue;
                controlBreakKeyList.add(controlBreakDefItem.getBreakKey());
            }
        }
        return new ControlBreakRowObject(next, controlBreakKeyList, this.controlBreakMap);
    }

    public ControlBreakRowObject setLastData(Object last) {
        this.transChunkControlBreakKeyList.clear();
        this.chunkNextData = new LinkedHashMap<String, Object>(this.chunkControlBreakDefItem.getBreakKey().size());
        this.nextData = new LinkedHashMap<String, Object>(this.controlBreakDefItemList.size());
        this.chunkControlBreak = true;
        ArrayList<List<String>> controlBreakKeyList = new ArrayList<List<String>>(this.controlBreakDefItemList.size());
        for (String propertyName : this.chunkControlBreakDefItem.getBreakKey()) {
            Object value = this.getBreakKeyValue(last, propertyName);
            this.chunkNextData.put(propertyName, value);
        }
        this.checkTransChunkControlBreak(this.chunkNextData.keySet());
        if (this.controlBreakDefItemList.size() > 0) {
            for (ControlBreakDefItem controlBreakDefItem : this.controlBreakDefItemList) {
                for (String propertyName : controlBreakDefItem.getBreakKey()) {
                    Object value = this.getBreakKeyValue(last, propertyName);
                    this.nextData.put(propertyName, value);
                    controlBreakKeyList.add(controlBreakDefItem.getBreakKey());
                }
            }
        }
        return new ControlBreakRowObject(END_MARK, controlBreakKeyList, this.nextData);
    }

    private void checkTransChunkControlBreak(Set<String> propertyNameSet) {
        if (this.transChunkControlBreakDefItemList == null) {
            return;
        }
        Object[] propertyNames = propertyNameSet.toArray(new String[propertyNameSet.size()]);
        ArrayUtils.reverse((Object[])propertyNames);
        block0: for (ControlBreakDefItem transChunkControlBreakDefItem : this.transChunkControlBreakDefItemList) {
            for (Object propertyName : propertyNames) {
                if (!transChunkControlBreakDefItem.getBreakKey().contains(propertyName)) continue;
                this.transChunkControlBreakKeyList.add(transChunkControlBreakDefItem.getBreakKey());
                continue block0;
            }
        }
    }

    public Map<String, Object> getChunkControlBreakMap() {
        return this.chunkControlBreakMap;
    }

    public List<List<String>> getTransChunkControlBreakKeyList() {
        return this.transChunkControlBreakKeyList;
    }

    public boolean isChunkControlBreak() {
        return this.chunkControlBreak;
    }

    public boolean isEndChunk() {
        return this.endChunk;
    }

    public void setEndChunk(boolean endChunk) {
        this.endChunk = endChunk;
    }

    public Map<String, Object> getNextData() {
        return this.nextData;
    }

    public Map<String, Object> getChunkNextData() {
        return this.chunkNextData;
    }

    private Object getBreakKeyValue(Object object, String breakKey) {
        if (this.methodMap == null) {
            try {
                PropertyDescriptor[] descriptors;
                HashSet<String> keySet = new HashSet<String>();
                for (String propertyName : this.chunkControlBreakDefItem.getBreakKey()) {
                    keySet.add(propertyName);
                }
                for (ControlBreakDefItem controlBreakDefItem : this.controlBreakDefItemList) {
                    for (String propertyName : controlBreakDefItem.getBreakKey()) {
                        if (keySet.contains(propertyName)) continue;
                        keySet.add(propertyName);
                    }
                }
                this.methodMap = new FastHashMap();
                BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                for (PropertyDescriptor descriptor : descriptors = beanInfo.getPropertyDescriptors()) {
                    if (!keySet.contains(descriptor.getName())) continue;
                    this.methodMap.put((Object)descriptor.getName(), (Object)descriptor.getReadMethod());
                }
            }
            catch (IntrospectionException e) {
                throw new JobException(e);
            }
        }
        try {
            Method method = (Method)this.methodMap.get((Object)breakKey);
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new JobException(e);
        }
        catch (InvocationTargetException e) {
            throw new JobException(e);
        }
    }

    public FastHashMap getMethodMap() {
        return this.methodMap;
    }

    public void setMethodMap(FastHashMap methodMap) {
        this.methodMap = methodMap;
    }
}

