/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample003;


import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;
import jp.terasoluna.batch.functionsample.common.NyusyukkinData;
import jp.terasoluna.batch.functionsample.common.SitenData;

/**
 * rWlXWbNNXB<br>
 * wb_--gCo͂B
 * 
 */
public class Sample003BLogic implements BLogic<SitenData, JobContext> {

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(Sample003BLogic.class);

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO;
    
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private FileUpdateDAO updateDAO;
    
    /**
     * t@Co̓fBNgB
     * SpringɂCX^Xݒ肳B
     */
    private String basePath;
    
    /**
     * NB
     */
    public BLogicResult execute(SitenData siten, JobContext arg1) {
    
    if(log.isDebugEnabled()){
        log.debug(siten.getSitenmei() + " start.");
    }

    // t@Co͗psC^̎擾
    FileLineWriter<NyusyukkinData> fileLineWriter 
        = updateDAO.execute(basePath + siten.getSitenmei() + ".csv", NyusyukkinData.class);

    try{
        //wb_̏o
        List<String> header = new ArrayList<String>();
        header.add("xXF" + siten.getSitenmei());
        header.add("ZF" + siten.getSitenjusyo());
        header.add("dbԍF" + siten.getSitentel());
        fileLineWriter.printHeaderLine(header);
        	
        //f[^̏o
        NyusyukkinData[] nyusyukkinArray = 	
        queryDAO.executeForObjectArray("SAMPLE003.getNyusyukkinDataBySiten", siten.getSitencd(), NyusyukkinData.class);
        
        long nyukinKingaku = 0L;
        long syukkinKingaku = 0L;
        for(NyusyukkinData nyusyukkin : nyusyukkinArray){

        	fileLineWriter.printDataLine(nyusyukkin);
        	
        	if(nyusyukkin.getNyusyukkincd() == 0){
        	    nyukinKingaku += nyusyukkin.getKingaku();
        	}else{
        	    syukkinKingaku += nyusyukkin.getKingaku();
        	}
        }
        
        //gC̏o
        List<String> trailer = new ArrayList<String>();
        trailer.add("vF" + nyukinKingaku);
        trailer.add("ovF" + syukkinKingaku);
        fileLineWriter.printTrailerLine(trailer);
    
    }finally{
        fileLineWriter.closeFile();
    }

    if(log.isDebugEnabled()){
        log.debug(siten.getSitenmei() + " end.");
    }
    
    
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(FileUpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
    
    /**
     * QueryDAOݒ肷B
     * @param queryDAO ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }
    
    /**
     * t@Co̓fBNgݒ肷B
     * @param basePath ݒ肷t@Co̓fBNg̃pX
     */
    public void setBasePath(String basePath){
    this.basePath = basePath;
    }
}
