/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.init;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorException;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobControlTableHandler;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobRequestInfoCollector
extends AbstractCollector {
    private static final Log log = LogFactory.getLog(JobRequestInfoCollector.class);
    protected JobControlTableHandler jobControlTableHandler = null;
    private long intervalSeconds = 0L;
    private int refreshCount = 0;
    protected String jobBeanPath = null;

    protected CollectorResult doCollect(JobContext jobContext, CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        int collected = 0;
        int processingCount = 0;
        JobInfo jobControlInfo = null;
        TransactionalJobStatus transactionalJobStatus = (TransactionalJobStatus)jobStatus;
        while (true) {
            if ((jobControlInfo = this.getJobMessageInfo(processingCount, jobControlInfo)) == null) {
                try {
                    Thread.sleep(this.intervalSeconds * 1000L);
                    processingCount = 0;
                }
                catch (InterruptedException e) {
                    throw new CollectorException(e, null);
                }
            }
            boolean commitFlag = false;
            transactionalJobStatus.beginTransaction();
            try {
                int count = this.updateJobStart(jobControlInfo);
                if (count == 1) {
                    if (this.jobBeanPath != null) {
                        this.overrideDescriptionPath(jobControlInfo);
                    }
                    collectedDataHandler.handle(jobControlInfo, collected++);
                    commitFlag = true;
                    if ("STOP".equals(jobControlInfo.getJobId().trim())) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"A stop record of an asynchronous batch daemon was recognized.");
                        }
                        CollectorResult collectorResult = new CollectorResult(ReturnCode.NORMAL_END, collected);
                        return collectorResult;
                    }
                }
            }
            catch (RuntimeException e) {
                throw new CollectorException(e, null);
            }
            finally {
                if (commitFlag) {
                    transactionalJobStatus.commit();
                } else {
                    transactionalJobStatus.rollback();
                }
            }
            if (++processingCount < this.refreshCount) continue;
            processingCount = 0;
        }
    }

    protected int updateJobStart(JobInfo jobInfo) {
        return this.jobControlTableHandler.updateJobStart(jobInfo);
    }

    protected JobInfo getJobMessageInfo(int selectCount, JobInfo jobInfo) {
        if (selectCount == 0) {
            return this.jobControlTableHandler.getJobRequestData();
        }
        return this.jobControlTableHandler.getJobRequestData(jobInfo);
    }

    protected void overrideDescriptionPath(JobInfo jobInfo) {
    }

    public void setJobControlTableHandler(JobControlTableHandler jobControlTableHandler) {
        this.jobControlTableHandler = jobControlTableHandler;
    }

    public void setIntervalSeconds(long intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public void setRefreshCount(int refreshCount) {
        this.refreshCount = refreshCount;
    }

    public void setJobBeanPath(String jobBeanPath) {
        throw new UnsupportedOperationException();
    }
}

