/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

/**
 * t@CǎpFileLineIteratorp̃NXB
 * 
 * <p>
 * t@CANZX(f[^擾)s3̃NX(CSVAŒ蒷Aϒ)
 * ɋʂ鏈܂Ƃ߂ۃNXB
 * t@C̎ނɑΉTuNXsB<br>
 * ݒ{@link jp.terasoluna.fw.file.dao.FileQueryDAO}QƂ̂ƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.file.dao.FileQueryDAO
 * @see jp.terasoluna.fw.file.dao.standard.CSVFileQueryDAO
 * @see jp.terasoluna.fw.file.dao.standard.FixedFileQueryDAO
 * @see jp.terasoluna.fw.file.dao.standard.VariableFileQueryDAO
 * @see jp.terasoluna.fw.file.dao.standard.PlainFileQueryDAO
 */
public abstract class AbstractFileQueryDAO implements FileQueryDAO {

    /**
     * Jp[T[i[}bvB
     */
    private Map<String, ColumnParser> columnParserMap = null;

    /**
     * t@Cw肵āA<code>FileLineIterator</code>擾B
     * 
     * @param <T> 1s̕i[t@CsIuWFNgNX
     * @param fileName t@Ci΃pX܂͑΃pX̂ǂ炩j
     * @param clazz 1s̕i[t@CsIuWFNgNX
     * @return t@CsIuWFNgp̃Ce[^
     */
    public abstract <T> FileLineIterator<T> execute(String fileName,
            Class<T> clazz);

    /**
     * Jp[T[i[}bv擾B
     * 
     * @return Jp[T[i[}bv
     */
    protected Map<String, ColumnParser> getColumnParserMap() {
        return columnParserMap;
    }

    /**
     * Jp[T[i[}bvݒ肷B
     * 
     * @param columnParserMap Jp[T[i[}bv
     */
    public void setColumnParserMap(Map<String, ColumnParser> columnParserMap) {
        this.columnParserMap = columnParserMap;
    }

}
