/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.usequeue;

import jp.terasoluna.fw.batch.commonj.WorkerExecutorService;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkQueueFactory;
import jp.terasoluna.fw.batch.standard.QueueProcessor;

import commonj.work.WorkItem;
import commonj.work.WorkManager;

/**
 * <code>WorkQueueFactory</code> C^tF[XCommonjpNXB
 * 
 * <p>
 * ̃NXł́A<coed>WorkManagerTaskWorkQueue</code> ̃CX^X쐬A 
 * 쐬<coed>WorkManagerTaskWorkQueue</code> ̃CX^Xp[^Ƃ
 * L[vZbTNƂŁAĂяoƂ 
 * <coed>WorkManagerTaskWorkQueue</code> ̃CX^XԂB
 * </p>
 * 
 */
public class WorkManagerTaskWorkQueueFactory implements WorkQueueFactory {

    /**
     * L[̒B
     */
    private int queueLength = 0;

    /**
     * L[vZbTB
     */
    private QueueProcessor queueProcessor = null;

    /**
     * [J[sT[rXB
     */
    private WorkerExecutorService workerExecutorService = null;

    /**
     * dsB
     */
    private int multiplicity = 1;

    /**
     * WuJn܂ł̃^CAEgi~bjB
     */
    private long workTimeout = WorkManager.INDEFINITE;

    /**
     * [NL[擾B
     * 
     * @param jobStatus WuXe[^X
     * @return [NL[
     */
    public WorkQueue getWorkQueue(JobStatus jobStatus) {
        WorkManagerTaskWorkQueue workQueue = new WorkManagerTaskWorkQueue(
                queueLength, jobStatus);

        workQueue.setWorkManager(workerExecutorService.getWorkManager());
        workQueue.setWorkTimeout(workTimeout);

        for (int i = 0; i < multiplicity; i++) {
            WorkItem workItem = workerExecutorService.submit(queueProcessor,
                    workQueue, jobStatus);
            workQueue.addWorkItem(workItem);
        }

        return workQueue;
    }

    /**
     * L[̒ݒ肷B
     * 
     * @param queueLength L[̒
     */
    public void setQueueLength(int queueLength) {
        if (queueLength <= 0) {
            StringBuffer buffer = new StringBuffer("QueueLength is illegal. ");
            buffer.append(queueLength);
            throw new InitializeException(buffer.toString());
        }
        this.queueLength = queueLength;
    }

    /**
     * L[vZbTݒ肷B
     * 
     * @param queueProcessor L[vZbT
     */
    public void setQueueProcessor(QueueProcessor queueProcessor) {
        this.queueProcessor = queueProcessor;
    }

    /**
     * [J[sT[rXݒ肷B
     * 
     * @param workerExecutorService [J[sT[rX
     */
    public void setWorkerExecutorService(
            WorkerExecutorService workerExecutorService) {
        this.workerExecutorService = workerExecutorService;
    }

    /**
     * dsݒ肷B
     * 
     * @param multiplicity ds
     */
    public void setMultiplicity(int multiplicity) {
        if (multiplicity <= 0) {
            StringBuffer buffer = new StringBuffer("Multiplicity is illegal. ");
            buffer.append(multiplicity);
            throw new InitializeException(buffer.toString());
        }
        this.multiplicity = multiplicity;
    }

    /**
     * WuJn܂ł̃^CAEgi~bj̐ݒB
     * 
     * @param workTimeout ^CAEgi~bj
     */
    public void setWorkTimeout(long workTimeout) {
        this.workTimeout = workTimeout;
    }
    
}
