/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao;

import java.util.Iterator;
import java.util.List;

/**
 * t@CANZX(f[^擾)p̃Ce[^C^tF[XB
 * <P>
 * eLXgt@Cǂ݁At@C̕t@CsIuWFNgɊi[B
 * FileLineIterator̃CX^XFileQueryDAOsB
 * ڍׂ{@link jp.terasoluna.fw.file.dao.FileQueryDAO}QƂ̂ƁB<br>
 * 
 * <strong>gp</strong><br>
 * <li>t@CsIuWFNg擾B
 * <pre><code>
 * // t@C1R[h̃f[^͂FileColumnSample^̃IuWFNgɊi[
 * cc
 *     while(fileLineIterator.<strong>hasNext()</strong>){
 *        FileColumnSample fileColumnSample = fileLineIterator.<strong>next()</strong>;
 * cc
 * </code></pre>
 * <strong></strong>FileLineIterator񋟂郁\bhB
 * ڍׂ{@link #hasNext()}A{@link #next()}QƂ̂ƁB
 * </P>
 * 
 * @param <T> t@CsIuWFNgB
 */
public interface FileLineIterator<T> extends Iterator {

    /**
     * t@Cf[^擾ł邩mFB
     * 
     * <p>
     * JԂłɗvfꍇ<code>true</code> ԂB 
     * </p>
     * 
     * @return qɗvfꍇ<code>true</code>B
     */
    boolean hasNext();

    /**
     * t@CsIuWFNgԋpB
     * 
     * <p>
     * <code>hasNext()</code>\bh<code>false</code>Ԃ܂
     * ̃\bhĂяoɁAt@CsIuWFNg1ԋpB
     * </p>
     * 
     * @return ̃t@CsIuWFNgB
     */
    T next();

    /**
     * wb_̕ԋpB
     * 
     * <p>
     * wb_̃f[^𕶎̃XgƂČĂяoɕԋpB
     * </p>
     * 
     * @return ^̃XgB
     */
    List<String> getHeader();

    /**
     * gC̕ԋpB
     * 
     * <p>
     * gC̃f[^𕶎̃XgƂČĂяoɕԋpB
     * </p>
     * 
     * @return ^̃XgB
     */
    List<String> getTrailer();

    /**
     * XLbvB
     * <p>
     * t@C͋@\ł́A͂JnswłB<br>
     * ɁAX^[g|Cgt@C̓ǍĊJƂɗpB
     * </p>
     * 
     * @param skipLines
     *            ǂݔ΂s
     */
    void skip(int skipLines);

    /**
     * t@CN[Y.
     * <p>
     * t@C̓̓Xg[B
     * t@C͂iKŕKs邱ƁB
     * </p>
     * 
     */
    void closeFile();

}
