/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.fw.batch.commonj.init.JobExecutor;
import jp.terasoluna.fw.batch.commonj.transaction.JobResultInfoHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.jobmessage.JobMessageInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import commonj.work.Work;
import commonj.work.WorkEvent;
import commonj.work.WorkItem;

/**
 * [N}l[WŎs郏[NiWuj̊ĎsNXB<br>
 * [N̊(Completed)A(Rejected)Ɏsʃnhɂ
 * nhOsB
 * 
 * 
 */
public class JobExecutorListener implements WorkMapListener {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(JobExecutorListener.class);

    /**
     * ƈ˗ۂꂽƂ̏IR[hB
     */
    private static final String REJECTED_JOB_EXIT_CODE = "-1";
    
    /**
     * XPW[ꂽ[Nێ}bvB
     */
    private Map<WorkItem, Work> map = 
        Collections.synchronizedMap(new HashMap<WorkItem, Work>());

    /**
     * WusʃnhB
     */
    private JobResultInfoHandler jobResultInfoHandler = null;

    /**
     * XPW[ꂽ[N̓o^B
     * 
     * @param workItem [N[N}lW[ŃXPW[Ƃ̕ԋpl
     * @param work XPW[[N
     */
    public void addWork(WorkItem workItem, Work work) {
        map.put(workItem, work);
        if (log.isDebugEnabled()) {
            log.debug("Map add work: " + workItem);
        }
    }

    /**
     * XPW[Ă郏[N̎擾B
     * 
     * @param workItem [N[N}lW[ŃXPW[Ƃ̕ԋpl
     * @return XPW[Ă郏[N
     */
    public Object getWork(WorkItem workItem) {
        return map.get(workItem);
    }

    /**
     * Ƃ[N폜B
     * 
     * @param workItem [N[N}lW[ŃXPW[Ƃ̕ԋpl
     * @return XPW[Ă郏[N
     */
    public Object removeWork(WorkItem workItem) {
        return map.remove(workItem);
    }

    /**
     * [ÑXPW[OB
     * 
     * @param we [NCxg
     */
    public void workAccepted(WorkEvent we) {
        printSimpleLog("Work accepted: ", getWork(we.getWorkItem()));
    }

    /**
     * [N̎sB
     * 
     * @param we [NCxg
     */
    public void workCompleted(WorkEvent we) {
        JobExecutor jobExecutor = (JobExecutor) removeWork(we.getWorkItem());
        JobStatus jobStatus = jobExecutor.getJobStatus();

        JobMessageInfo jobMessageInfo = 
            createJobMessageInfo(jobStatus, jobExecutor);

        printLog("Work completed: ", jobMessageInfo, jobStatus);

        try {
            jobResultInfoHandler.handle(jobMessageInfo);
        } catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! JobID: ");
            logStr.append(jobStatus.getJobId());
            logStr.append(" ");
            logStr.append(throwable.getMessage());
            log.error(logStr.toString(), throwable);
        } finally {
            jobExecutor.destroy();
        }
        
    }

    /**
     * [ÑXPW[OہB
     * 
     * @param we [NCxg
     */
    public void workRejected(WorkEvent we) {
        JobExecutor jobExecutor = (JobExecutor) removeWork(we.getWorkItem());
        JobStatus jobStatus = null;
        JobMessageInfo jobMessageInfo = null;
        if (jobExecutor != null) {
            jobStatus = jobExecutor.getJobStatus();
            jobMessageInfo = createJobMessageInfo(jobStatus, jobExecutor);
            jobMessageInfo.setJobExitCode(REJECTED_JOB_EXIT_CODE);
            printLog("Work rejected: ", jobMessageInfo, jobStatus);
            try {
                jobResultInfoHandler.handle(jobMessageInfo);
            } catch (Throwable throwable) {
                StringBuilder logStr = new StringBuilder();
                logStr.append("Critical Error!! JobID: ");
                logStr.append(jobStatus.getJobId());
                logStr.append(" ");
                logStr.append(throwable.getMessage());
                log.error(logStr.toString(), throwable);
            } finally {
                jobExecutor.destroy();
            }
        }

    }

    /**
     * [N̎sJnB
     * 
     * @param we [NCxg
     */
    public void workStarted(WorkEvent we) {
        printSimpleLog("Work started: ", getWork(we.getWorkItem()));
    }

    /**
     * Wusʃnh̐ݒB
     * 
     * @param jobResultInfoHandler Wusʃnh
     */
    public void setJobResultInfoHandler(
            JobResultInfoHandler jobResultInfoHandler) {
        this.jobResultInfoHandler = jobResultInfoHandler;
    }

    
    /**
     * WubZ[WǗ쐬B
     *  
     * @param jobStatus WuXe[^X
     * @param jobExecutor ƈ˗ꂽWuNNX
     * @return WubZ[WǗ
     */
    private JobMessageInfo createJobMessageInfo(
            JobStatus jobStatus, JobExecutor jobExecutor) {
        JobMessageInfo jobMessageInfo = new JobMessageInfo();
        jobMessageInfo.setJobRequestNo(jobStatus.getJobRequestNo());
        jobMessageInfo.setJobId(jobStatus.getJobId());
        jobMessageInfo.setJobExitCode(String
                .valueOf(jobStatus.getJobExitCode()));
        jobMessageInfo.setJobState(String.valueOf(jobStatus.getJobState()
                .ordinal()));
        jobMessageInfo.setPartitionNo(jobStatus.getPartitionNo());
        jobMessageInfo.setPartitionKey(jobStatus.getPartitionKey());
        jobMessageInfo.setJobDiscriptorPath(jobExecutor.getJobInfo()
                .getJobDiscriptorPath());
        
        return jobMessageInfo;
    }
    
    /**
     * OóB
     * 
     * @param message ObZ[W
     * @param jobMessageInfo WubZ[WǗ
     * @param jobStatus WubZ[W@
     */
    private void printLog(String message, JobMessageInfo jobMessageInfo, 
            JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append("[AsyncJob] [JobRequestNo = ");
            builder.append(jobStatus.getJobRequestNo());
            builder.append("] [JobId = ");
            builder.append(jobStatus.getJobId());
            builder.append("] [PartitionNo = ");
            builder.append(jobMessageInfo.getPartitionNo());
            builder.append("] [ExitCode = ");
            builder.append(jobMessageInfo.getJobExitCode());
            builder.append("] [JobState = ");
            builder.append(jobMessageInfo.getJobState());
            builder.append("]");
            log.debug(builder.toString());
        }
    }
    
    /**
     * ȒPȃOóB
     * 
     * @param message ObZ[W
     * @param object o̓IuWFNg
     */
    private void printSimpleLog(String message, Object object) {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder(message);
            builder.append("[AsyncJob] ");
            builder.append(object);
            builder.append("]");
            log.debug(builder.toString());
        }
    }
}
