/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.core;

import jp.terasoluna.fw.batch.openapi.ReturnCode;

/**
 * ʌJEgNXB
 * 
 * <p>rWlXWbNAOE㏈Ȃǂ̃T|[gȂǁA
 * <code>ReturnCode</code>ԋp̂ɂāA̎sJEgB
 * <code>ReturnCode</code> ̂Api<code>ReturnCode.NORMAL_CONTINUE
 * </code>jAُpi<code>ReturnCode.ERROR_CONTINUE</code>ĵ݃JEgA
 * ̌ێB</p>
 * 
 */
public class ResultCounter {

    /**
     * p̏ʌB
     */
    private int normalContinueCount = 0;

    /**
     * ُp̏ʌB
     */
    private int errorContinueCount = 0;

    /**
     * JEgB
     * 
     * @param returnCode JEg郊^[R[h
     */
    public void count(ReturnCode returnCode) {
        switch (returnCode) {
            case NORMAL_CONTINUE :
                normalContinueCount++;
                break;
            case ERROR_CONTINUE :
                errorContinueCount++;
                break;
            default :
                // NORMAL_CONTINUEAERROR_CONTINUEȊO̓JEgȂB
                break;
        }
    }

    /**
     * ُp̏ʌ擾B
     * 
     * @return ُp̏ʌ
     */
    public int getErrorContinueCount() {
        return errorContinueCount;
    }

    /**
     * p̏ʌ擾B
     * 
     * @return p̏ʌ
     */
    public int getNormalContinueCount() {
        return normalContinueCount;
    }
    
    /**
     * 擾B
     * 
     * @return 
     */
    public int getToralCount() {
        return normalContinueCount + errorContinueCount;
    }
}
