/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobManager;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.restart.JobRestartTableHandler;
import jp.terasoluna.fw.batch.restart.RestartJobStatus;
import jp.terasoluna.fw.batch.springsupport.init.JobStarter;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobContextRestorer
implements Workable<WorkUnit> {
    private static Log log = LogFactory.getLog(JobStarter.class);
    private JobManager jobManager = null;
    private JobRestartTableHandler jobRestartTableHandler = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    @Override
    public void work(WorkUnit element, JobStatus jobStatus) {
        JobContext jobContext = element.getJobContext();
        JobStatus childJobStatus = jobStatus.getChild(element.getJobContext());
        JobContext newJobContext = null;
        try {
            try {
                newJobContext = this.jobRestartTableHandler.getRestartJobContext(jobContext, childJobStatus);
            }
            catch (JobException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                childJobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
                return;
            }
            if (!childJobStatus.isContinue()) {
                return;
            }
            newJobContext.setRestartable(true);
            childJobStatus.setRestartable(true);
            element.setJobContext(newJobContext);
            RestartJobStatus restartJobStatus = new RestartJobStatus(childJobStatus);
            this.jobManager.work(element, (JobStatus)restartJobStatus);
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(newJobContext, throwable, childJobStatus);
        }
    }

    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void setJobRestartTableHandler(JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

