/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.annotation;

import org.hibernate.HibernateException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class AnnotationSessionFactoryBean
extends LocalSessionFactoryBean {
    private Class[] annotatedClasses;
    private String[] annotatedPackages;

    public AnnotationSessionFactoryBean() {
        this.setConfigurationClass(AnnotationConfiguration.class);
    }

    public void setConfigurationClass(Class configurationClass) {
        if (configurationClass == null || !AnnotationConfiguration.class.isAssignableFrom(configurationClass)) {
            throw new IllegalArgumentException("AnnotationSessionFactoryBean only supports AnnotationConfiguration or subclasses");
        }
        super.setConfigurationClass(configurationClass);
    }

    public void setAnnotatedClasses(Class[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setAnnotatedPackages(String[] annotatedPackages) {
        this.annotatedPackages = annotatedPackages;
    }

    protected final void postProcessConfiguration(Configuration config) throws HibernateException {
        int i;
        AnnotationConfiguration annConfig = (AnnotationConfiguration)config;
        if (this.annotatedClasses != null) {
            for (i = 0; i < this.annotatedClasses.length; ++i) {
                annConfig.addAnnotatedClass(this.annotatedClasses[i]);
            }
        }
        if (this.annotatedPackages != null) {
            for (i = 0; i < this.annotatedPackages.length; ++i) {
                annConfig.addPackage(this.annotatedPackages[i]);
            }
        }
        this.postProcessAnnotationConfiguration(annConfig);
    }

    protected void postProcessAnnotationConfiguration(AnnotationConfiguration config) throws HibernateException {
    }
}

