package upload.blogic;

import java.io.File;
import java.io.IOException;
import java.util.Locale;

import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.multipart.MultipartFile;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.rich.BLogic;
import upload.dto.FileUploadDs;
import upload.dto.ResultTable;

/**
 * Abv[hBLogicB
 */
public class UploadBLogic implements BLogic<FileUploadDs, FileUploadDs> {

    /**
     * \[Xꎞt@C̕ۑfBNg擾L[B
     */
    private static String tmpDirKey = "tmpDir";

    /**
     * bZ[W擾NXB
     */
    private ResourceBundleMessageSource messageSource = null;

    /**
     * bZ[W擾NXsetterB
     */
    public void setMessageSource(ResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    /**
     * Abv[hsB
     */
    public FileUploadDs execute(FileUploadDs param) {

        ResultTable resultBean = new ResultTable();
        resultBean.setResult(true);

        if (param.getFile01() != null) {
            saveFile(param.getFile01());
        }
        if (param.getFile02() != null) {
            saveFile(param.getFile02());
        }
        if (param.getFile03() != null) {
            saveFile(param.getFile03());
        }
        if (param.getFile04() != null) {
            saveFile(param.getFile04());
        }
        if (param.getFile05() != null) {
            saveFile(param.getFile05());
        }
        if (param.getFile06() != null) {
            saveFile(param.getFile06());
        }
        if (param.getFile07() != null) {
            saveFile(param.getFile07());
        }
        if (param.getFile08() != null) {
            saveFile(param.getFile08());
        }
        if (param.getFile09() != null) {
            saveFile(param.getFile09());
        }
        if (param.getFile10() != null) {
            saveFile(param.getFile10());
        }

        FileUploadDs resultDs = new FileUploadDs();
        resultDs.setResultTable(resultBean);
        return resultDs;
    }

    /**
     * Abv[hꂽt@CۑB
     */
    private void saveFile(MultipartFile paramFile) {

        String fileName = messageSource.getMessage(tmpDirKey,
                new Object[] { paramFile.getOriginalFilename() }, Locale.JAPAN);
        File file = new File(fileName);

        try {
            paramFile.transferTo(file);
        } catch (IllegalStateException e) {
            throw new SystemException(e);
        } catch (IOException e) {
            throw new SystemException(e);
        }
    }

}
