using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Web.Controller;
using TERASOLUNA.Fw.Web.BLogic;
using System.Collections.Generic;
using TutorialServerRich.Dto;
using TERASOLUNA.Fw.Common.BLogic;
using System.IO;

namespace TutorialServerRich.BLogic
{
    /// <summary>
    /// }`p[g`̃Abv[hs <see cref="IUploadBLogic"/> NXłB
    /// </summary>
    [ControllerInfo(RequestType = RequestTypeNames.MULTIPART_UPLOAD)]
    public class MultipartUploadBLogic : IUploadBLogic
    {
        /// <summary>
        /// MĂ}`p[gf[^ێtB[hB
        /// </summary>
        private IDictionary<string, IMultipartItem> _multipartItemList = null;

        /// <summary>
        /// MĂ}`p[gf[^̐ݒE擾܂B
        /// </summary>
        public IDictionary<string, IMultipartItem> MultipartItemList
        {
            get
            {
                return _multipartItemList;

            }
            set
            {
                _multipartItemList = value;
            }
        }
        
        /// <summary>
        /// t@CAbv[h̃fBNg[
        /// </summary>
        private static readonly string UPLOAD_FILE_DIRECTORY = "~/Work/{0}";

        /// <summary>
        /// }`p[g`̃Abv[hs܂B
        /// </summary>
        /// <param name="param">rWlXbN̓NXB</param>
        /// <returns>rWlXWbNʃNXB</returns>
        public BLogicResult Execute(BLogicParam param)
        {
            FileUploadDs resultDs = new FileUploadDs();
            if (_multipartItemList.Count != 0)
            {
                resultDs.ResultTable.AddResultTableRow(true);
            }
            else
            {
                resultDs.ResultTable.AddResultTableRow(false);
            }

            foreach (IMultipartItem item in _multipartItemList.Values)
            {
                // t@Cǂ̃`FbN
                if (!item.IsText)
                {
                    MultipartFileItem fileItem = item as MultipartFileItem;
                    string uploadFileName = string.Format(UPLOAD_FILE_DIRECTORY, Path.GetFileName(fileItem.Filename));
                    string fileName = HttpContext.Current.Server.MapPath(uploadFileName);
                    using (FileStream stream = new FileStream(fileName, FileMode.Create))
                    {
                        byte[] buffer = new byte[256];
                        int readsize = 0;
                        while ((readsize = fileItem.OutputStream.Read(buffer, 0, 256)) != 0)
                        {
                            stream.Write(buffer, 0, readsize);
                        }
                        stream.Flush();
                    }
                }
                else
                {
                    //eLXg̏ꍇ́AȗB
                }
            }
            return new BLogicResult(BLogicResult.SUCCESS, resultDs);
        }
    }
}
