using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using TERASOLUNA.Fw.Web.Controller;
using TutorialServerRich.Dto;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Web.Validation;

namespace TutorialServerRich.BLogic
{
    /// <summary>
    /// |ZsrWlXWbNłB
    /// </summary>
    [ControllerInfo(RequestType = RequestTypeNames.NORMAL, InputDataSetType = typeof(CalcFormDs))]
    [ValidationInfo(ValidationFilePath = @"Validation\CalcFormDsValidation.config", RuleSet = "Default")]
    public class CalcBLogic : IBLogic
    {
        /// <summary>
        /// |ZsrWlXWbNłB
        /// </summary>
        /// <param name="param">rWlXWbN̓NX</param>
        /// <returns>rWlXWbNʃNX</returns>
        public BLogicResult Execute(BLogicParam param)
        {
            // |Zs߂̒l̎擾
            CalcFormDs inputDs = param.ParamData as CalcFormDs;
            int numberA = Int32.Parse(inputDs.CalcTable[0].NumberA);
            int numberB = Int32.Parse(inputDs.CalcTable[0].NumberB);

            // |Z̎s
            int answer = numberA * numberB;

            // |ZrWlXWbNʃNXɊi[f[^Zbg̍쐬
            CalcFormDs outputDs = new CalcFormDs();
            outputDs.CalcTable.AddCalcTableRow(null, null, answer);

            // |ZrWlXWbŇʃNX̍쐬
            return new BLogicResult(BLogicResult.SUCCESS, outputDs);
        }
    }
}
