﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Threading;
using System.Diagnostics;
using System.Configuration;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Client.Communication;

namespace TutorialClient
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.ThreadException +=
                new ThreadExceptionEventHandler(Application_ThreadException);

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            // TODO アプリケーションのルートとなるフォームを作成します。
            LogonForm applicationForm = new LogonForm();
            applicationForm.Init(null);

            Application.Run(applicationForm);
        }

        /// <summary>
        /// アプリケーションコードから処理されない例外をハンドルするメソッドです。
        /// </summary>
        /// <remarks>
        /// <para>
        /// アプリケーションでは、catchされない例外は全てこの例外ハンドラによって
        /// 処理されます。
        /// </para>
        /// <para>
        /// デフォルトでは例外のメッセージをダイアログボックスに表示します。
        /// </para>
        /// </remarks>
        /// <param name="Sender">イベントのソース。</param>
        /// <param name="e">例外ブロックに渡される例外クラス。</param>
        static void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
        {
           MessageBox.Show("システムエラーが発生しました。管理者に問い合わせてください。","システムエラー", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }
    }
}