﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using TERASOLUNA.Fw.Client.Forms;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common;

namespace TutorialClient
{
    /// </summary>
    /// ログオン認証を行う画面です。
    /// </summary>
    /// <remarks>
    /// ログオン認証処理を行います。
    /// </remarks>
    public partial class LogonForm : FormBase
    {
        /// <summary>
        /// <see cref="LogonForm"/>クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public LogonForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// フォームロード時に実行されるイベントハンドラです。
        /// </summary>
        /// <remarks>
        /// <para>画面データセットを初期化します。</para>
        /// </remarks>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        private void LogonForm_Load(object sender, EventArgs e)
        {
            logonFormDs.LogonTable.AddLogonTableRow(logonFormDs.LogonTable.NewLogonTableRow());
        }

        /// <summary>
        /// ログオンボタン押下時に実行されるイベントハンドラです。
        /// </summary>
        /// <remarks>ログオン認証処理を実行します。</remarks>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="EventArgs"/>。</param>
        private void logonButton_Click(object sender, EventArgs e)
        {
            ExecutionResult result = logonEvent.Execute();

            if (result.Success)
            {
                Items["UserId"] = userIdTextBox.Text;
                logonFormForwarder.Execute();
                this.Visible = false;
            }
            else
            {
                if (result.Errors.Count != 0)
                {
                    string message = result.Errors[0].Message;
                    MessageBox.Show(message);
                }
            }
        }

        /// <summary>
        /// ログオン画面のクローズ時に呼ばれるイベントハンドラです。
        /// </summary>
        /// <param name="sender">イベントのソース。</param>
        /// <param name="e">イベントデータを格納している<see cref="ForwardableFormCloseEventArgs"/>。</param>
        /// <remarks>メニュー画面へ画面遷移後ログオン画面を閉じます。</remarks>
        private void logonFormForwarder_FormClosed(object sender, ForwardableFormCloseEventArgs e)
        {
            this.Close(); 
        }
    }
}