﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using TERASOLUNA.Fw.Client.Forms;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Client.BLogic;
using TERASOLUNA.Fw.Common;
using TutorialClient.ViewData;

namespace TutorialClient
{
    /// <summary>
    /// ファイルアップロードを行う画面です。
    /// </summary>
    /// <remarks>
    /// サーバへアップロードするファイルを複数選択しアップロードします。
    /// </remarks>
    public partial class FileUploadForm : FormBase
    {
        /// <summary>
        /// <see cref="CalcForm"/>クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public FileUploadForm()
        {
            InitializeComponent();
        }

        private void uploadButton_Click(object sender, EventArgs e)
        {
            // ファイルが0個でないことのチェック
            if (fileUploadDs.File.Count == 0)
            {
                MessageBox.Show(Properties.Resources.UPLOAD_SELECT);
                return;
            }

            // ファイルアップロード処理の実行
            ExecutionResult result = uploadEvent.Execute();

            //サーバとの通信成功         
            if (result.Success)
            {
                FileUploadDs resultDs = result.BLogicResultData as FileUploadDs;
                if (resultDs.ResultTable[0].Result)
                {
                    //サーバビジネスロジック正常終了
                    MessageBox.Show(Properties.Resources.UPLOAD_SUCCESS, Properties.Resources.UPLOAD_FORM_SUCCESS);
                }
                else
                {
                    //サーバビジネスロジック業務エラー
                    MessageBox.Show(Properties.Resources.UPLOAD_FAILURE, Properties.Resources.UPLOAD_FORM_FAILURE);
                }
            }
        }

        private void addButton_Click(object sender, EventArgs e)
        {
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                int count = fileUploadDs.File.Rows.Count + 1;
                string name = "file" + count.ToString("00");
                fileUploadDs.File.AddFileRow(name, openFileDialog.FileName);
                fileUploadDs.AcceptChanges();
            }
        }

        private void clearButton_Click(object sender, EventArgs e)
        {
            fileUploadDs.File.Clear();
            fileUploadDs.AcceptChanges();
        }
    }
}