﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using TERASOLUNA.Fw.Client.Forms;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Client.BLogic;
using TERASOLUNA.Fw.Common;
using TutorialClient.ViewData;

namespace TutorialClient
{
    /// <summary>
    /// ファイルダウンロードを行う画面です。
    /// </summary>
    /// <remarks>
    /// サーバからテキスト形式のファイル、CSV形式のファイル、PNG形式のファイル
    /// を一つ選択してダウンロードします。
    /// </remarks>
    public partial class FileDownloadForm : FormBase
    {
        /// <summary>
        /// <see cref="CalcForm"/>クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public FileDownloadForm()
        {
            InitializeComponent();
        }

        private void FileDownloadForm_Load(object sender, EventArgs e)
        {
            fileDownloadDs.FileTable.AddFileTableRow(fileDownloadDs.FileTable.NewFileTableRow());
        }

        private void downloadEvent_ExecuteProgressChanged(object sender, ExecuteProgressChangedEventArgs e)
        {
            // サーバから正常にデータを受信した場合（ダウンロード準備完了）
            if (e.Items.Contains(BinaryFileDownloadBLogic.DOWNLOAD_READY))
            {
                // サーバから受信したファイル名の取得
                string contentFileName = e.Items[BinaryFileDownloadBLogic.CONTENT_FILENAME] as string;

                // ファイル保存ダイアログを利用したダウンロードファイルパスの決定
                saveFileDialog.InitialDirectory = Properties.Resources.DOWNLOAD_PATH;
                saveFileDialog.FileName = contentFileName;
                if (DialogResult.OK == saveFileDialog.ShowDialog())
                {
                    // ダウンロードファイルパスの設定
                    e.Items.Add(BinaryFileDownloadBLogic.DOWNLOAD_FILEPATH, saveFileDialog.FileName);
                }
                else
                {
                    if (downloadEvent.Items.Keys.Contains(BinaryFileDownloadBLogic.DOWNLOAD_FILEPATH))
                    {
                        downloadEvent.Items.Remove(BinaryFileDownloadBLogic.DOWNLOAD_FILEPATH);
                    }
                }
            }
        }

        private void downloadEvent_Preprocessed(object sender, PreprocessedEventArgs e)
        {
            FileDownloadDs blogicParamData = e.BLogicParamData as FileDownloadDs;
            blogicParamData.FileTable.AddFileTableRow(blogicParamData.FileTable.NewFileTableRow());

            //ダウンロードファイルの選択
            if (fileDownloadDs.FileTable[0].RadioTextFile)
            {
                blogicParamData.FileTable[0].FileName = "てらそるな.txt";
            }
            else if (fileDownloadDs.FileTable[0].RadioCsvFile)
            {
                blogicParamData.FileTable[0].FileName = "てらそるな.csv";
            }
            else if (fileDownloadDs.FileTable[0].RadioPngFile)
            {
                blogicParamData.FileTable[0].FileName = "てらそるな.png";
            }
            else
            {
                MessageBox.Show(Properties.Resources.DOWNLOAD_SELECT, Properties.Resources.DOWNLOAD_FORM_FAILURE);
            }

        }

        private void fileDownloadButton_Click(object sender, EventArgs e)
        {
            //ダウンロード処理の実行
            ExecutionResult result = downloadEvent.Execute();

            //サーバとの通信成功      
            if (result.Success)
            {
                // ダウンロードが成功したことを画面に表示する
                if (downloadEvent.Items.Keys.Contains(BinaryFileDownloadBLogic.DOWNLOAD_FILEPATH))
                {
                    //サーバビジネスロジック正常終了
                    string message = string.Format(Properties.Resources.DOWNLOAD_SUCCESS, downloadEvent.Items[BinaryFileDownloadBLogic.DOWNLOAD_FILEPATH].ToString());
                    MessageBox.Show(message, Properties.Resources.DOWNLOAD_FORM_SUCCESS);
                }
            }
            else
            {
                //サーバビジネスロジック業務エラー
                MessageBox.Show(Properties.Resources.DOWNLOAD_FAILURE, Properties.Resources.DOWNLOAD_FORM_FAILURE);
            }
        }
    }
}