﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using TERASOLUNA.Fw.Client.Forms;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common;

namespace TutorialClient
{
    /// <summary>
    /// 掛け算を行う画面です。
    /// </summary>
    /// <remarks>
    /// 数値Aと数値Bの掛け算の結果を表示します。
    /// </remarks>
    public partial class CalcForm : FormBase
    {
        /// <summary>
        /// <see cref="CalcForm"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public CalcForm()
        {
            InitializeComponent();
        }

        private void CalcForm_Load(object sender, EventArgs e)
        {
            calcFormDs.CalcTable.AddCalcTableRow(
                calcFormDs.CalcTable.NewCalcTableRow());
        }

        private void calcButton_Click(object sender, EventArgs e)
        {
            ExecutionResult result = calcEvent.Execute();

            if (result.Errors.Count != 0)
            {
                string message = result.Errors[0].Message;
                MessageBox.Show(message);
            }
        }
    }
}