﻿using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Client.BLogic;
using TutorialClient.ViewData;
using System.Data;
using TERASOLUNA.Fw.Common;

namespace TutorialClient.BLogic
{
    /// <summary>
    /// ログオン認証を行う <see cref="ClientBLogicBase"/> 実装クラスです。
    /// </summary>
    public class LogonBLogic : ClientBLogicBase
    {
        private static readonly string USER_ID = "tera";
        private static readonly string PASSWORD = "soluna";
        private static readonly string FAILURE = "FAILURE";

        /// <summary>
        /// ログオン認証を行います。
        /// </summary>
        /// <param name="param">ビジネスロジック入力クラス。</param>
        /// <returns>ビジネスロジック結果クラス。</returns>
        public override BLogicResult Execute(BLogicParam param)
        {
            // ユーザ ID とパスワードの取得
            LogonFormDs resultData = param.ParamData as LogonFormDs;
            string id = resultData.LogonTable[0].Id;
            string pass = resultData.LogonTable[0].Pass;

            if (USER_ID.Equals(id) && PASSWORD.Equals(pass))
            {
                //ログオン成功時のビジネスロジック結果クラスの作成
                return new BLogicResult(BLogicResult.SUCCESS, new DataSet());
            }
            else
            {
                //ログオン失敗時のビジネスロジック結果クラスの作成
                BLogicResult blogicResult = new BLogicResult(FAILURE);
                MessageInfo errorMessageInfo = new MessageInfo(Properties.Resources.E_LOGIN_FAILURE);
                blogicResult.Errors.Add(errorMessageInfo);
                return blogicResult;
            }
        }
    }
}
