﻿using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.BLogic;
using TERASOLUNA.Fw.Common.BLogic;
using TutorialClient.ViewData;

namespace TutorialClient.BLogic
{
    /// <summary>
    /// 掛け算を行う <see cref="IBLogic"/> 実装クラスです。
    /// </summary>
    public class CalcBLogic : IBLogic
    {
        /// <summary>
        /// 掛け算を行ういます。
        /// </summary>
        /// <param name="paramData">ビジネスロジック入力クラス。</param>
        /// <returns>ビジネスロジック結果クラス。</returns>
        public BLogicResult Execute(BLogicParam param)
        {
            // 掛け算を行うための値の取得
            CalcFormDs inputDs = param.ParamData as CalcFormDs;
            int numberA = Int32.Parse(inputDs.CalcTable[0].NumberA);
            int numberB = Int32.Parse(inputDs.CalcTable[0].NumberB);

            // 掛け算の実行
            int answer = numberA * numberB;

            // 掛け算ビジネスロジック結果クラスに格納するデータセットの作成
            CalcFormDs outputDs = new CalcFormDs();
            outputDs.CalcTable.AddCalcTableRow(null, null, answer);

            // 掛け算ビジネスロジックの結果クラスの作成
            return new BLogicResult(BLogicResult.SUCCESS, outputDs);
        }    
    }
}
