// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.Sql
{
    /// <summary>
    /// SQL ݒt@C sql vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="SqlElement"/> ́A SQL ݒt@C sql vf\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElement"/> QƂĂB
    /// </remarks>
    public sealed class SqlElement : ConfigurationElement
    {

        /// <summary>
        /// name ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "name" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_NAME = "name";

        /// <summary>
        /// statement ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "statement" łB
        /// </remarks>
        private const string STATEMENT_ATTRIBUTE_NAME = "statement";

        /// <summary>
        /// <see cref="SqlElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public SqlElement()
        {
        }

        /// <summary>
        /// <see cref="SqlElement"/> NX̐VCX^X쐬܂B
        /// </summary>
        /// <param name="name">name ̒lB</param>
        /// <param name="statement">statement ̒lB</param>
        /// <remarks>
        /// name Astatement ̒l nameAstatement ŏ܂B
        /// </remarks>
        public SqlElement(string name, string statement)
        {
            this[NAME_ATTRIBUTE_NAME] = name;
            this[STATEMENT_ATTRIBUTE_NAME] = statement;
        }

        /// <summary>
        /// name ̒l擾܂B
        /// </summary>
        /// <value>
        /// name ̒lB
        /// </value>
        [ConfigurationProperty(NAME_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Name
        {
            get
            {
                return (string)this[NAME_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// statement ̒l擾܂B
        /// </summary>
        /// <value>
        /// statement ̒lB
        /// </value>
        [ConfigurationProperty(STATEMENT_ATTRIBUTE_NAME, IsRequired = true)]
        public string Statement
        {
            get
            {
                return (string)this[STATEMENT_ATTRIBUTE_NAME];
            }
        }
    }
}
