// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.Page
{
    /// <summary>
    /// \t@C pageConfiguration ZNV\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ConfigurationSection"/> NXgApageConfiguration JX^\nhłB
    /// ڍׂɂẮA<see cref="ConfigurationSection"/> QƂĂB
    /// </remarks>
    public class PageConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// pageConfiguration ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "pageConfiguration" łB
        /// </remarks>
        private const string PAGE_CONFIGURAION_SECTION_NAME = "pageConfiguration";

        /// <summary>
        /// <see cref="FilesCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "files" łB
        /// </remarks>
        private const string FILES_ELEMENT_NAME = "files";

        /// <summary>
        /// <see cref="PagesCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "pages" łB
        /// </remarks>
        private const string PAGE_ELEMENT_NAME = "pages";

        /// <summary>
        /// Oݒt@CXMLOԃvtBbNXłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "page" łB
        /// </remarks>
        private const string XML_NAMESPACE_PREFIX = "page";

        /// <summary>
        /// Oݒt@CXMLOԂłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "http://www.terasoluna.jp/schema/PageSchema.xsd" łB
        /// </remarks>
        private const string XML_NAMESPACE = "http://www.terasoluna.jp/schema/PageSchema.xsd";

        /// <summary>
        /// Oݒt@C page ZNVvf擾p XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "page:pageConfiguration" łB
        /// </remarks>
        private const string PAGE_SECTION_XPATH = XML_NAMESPACE_PREFIX + ":pageConfiguration";

        /// <summary>
        /// Oݒt@C page vf擾p XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "page:pageConfiguration/page:page" łB
        /// </remarks>
        private const string PAGE_ELEMENT_XPATH = PAGE_SECTION_XPATH + "/" + XML_NAMESPACE_PREFIX + ":page";

        /// <summary>
        /// XMLXL[}t@C̊SłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA.Fw.Web.Configuration.Page.PageConfiguration.xsd" łB
        /// </remarks>
        private const string PAGE_SCHEMA_NAME = "TERASOLUNA.Fw.Web.Configuration.Page.PageConfiguration.xsd";

        /// <summary>
        /// <see cref="PageConfigurationSection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public PageConfigurationSection()
        {
        }

        /// <summary>
        /// files vf擾܂B
        /// </summary>
        /// <remarks>
        /// pageConfiguration ZNVA <see cref="FilesCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(FILES_ELEMENT_NAME, IsDefaultCollection = false)]
        public FilesCollection Files
        {
            get
            {
                FilesCollection filesCollection = (FilesCollection)base[FILES_ELEMENT_NAME];
                return filesCollection;
            }
        }

        /// <summary>
        /// pages vf擾܂B
        /// </summary>
        /// <remarks>
        /// pageConfiguration ZNVA <see cref="PagesCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(PAGE_ELEMENT_NAME, IsDefaultCollection = false, IsRequired = false)]
        public PagesCollection Pages
        {
            get
            {
                PagesCollection pagesCollection = (PagesCollection)base[PAGE_ELEMENT_NAME];
                return pagesCollection;
            }
        }

        /// <summary>
        /// files vf̐ݒe page vf𐶐 pages vfɒǉ܂B
        /// </summary>
        /// <remarks>
        /// <para><see cref="MergeConfiguration"/> IuWFNg𐶐AOݒt@C̐ݒ}[W܂B</para>
        /// <para>}[WOݒt@C̓e <see cref="PageElement"/> IuWFNg𐶐A
        /// <see cref="PagesCollection"/> RNVɒǉ܂B</para>
        /// </remarks>
        /// <exception cref="ArgumentException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH słB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŃ}[Wvf XPATH słB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public virtual void CreatePageElements()
        {
            // Oݒt@C̐ݒe}[W
            MergeConfiguration mgConfig = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, PAGE_SCHEMA_NAME);
            mgConfig.LoadConfig(PAGE_CONFIGURAION_SECTION_NAME, Files);
            XmlDocument xmlDoc = mgConfig.MergeXmlDocument(PAGE_SECTION_XPATH, PAGE_ELEMENT_XPATH);

            // ݒePagesvpeBɕێ
            AddPageElements(xmlDoc);

        }

        /// <summary>
        /// Oݒt@C̓e page vf𐶐Apages vfɒǉ܂B
        /// </summary>
        /// <param name="xmlDoc">Oݒt@C̓eێ <see cref="System.Xml.XmlDocument" /> B</param>
        private void AddPageElements(XmlDocument xmlDoc)
        {
            // PAGEʎq
            const string NAME_ATTRIBUTE_NAME = "name";
            const string NAME_ATTRIBUTE_PATH = "path";
            const string NAME_ATTRIBUTE_PDS = "preventDoubleSubmit";
            const string NAME_ATTRIBUTE_SETTOKEN = "setToken";
            const string NAME_ATTRIBUTE_CHECKTOKEN = "checkToken";
            const string NAME_ATTRIBUTE_UPDATETOKEN = "updateToken";

            XmlNamespaceManager xmlNM = new XmlNamespaceManager(xmlDoc.NameTable);
            xmlNM.AddNamespace(XML_NAMESPACE_PREFIX, XML_NAMESPACE);
            XmlNodeList xmlNL = xmlDoc.SelectNodes(PAGE_ELEMENT_XPATH, xmlNM);

            foreach (XmlNode xmlNode in xmlNL)
            {
                string name = xmlNode.Attributes[NAME_ATTRIBUTE_NAME].InnerText;
                string path = xmlNode.Attributes[NAME_ATTRIBUTE_PATH].InnerText;
                string pds = xmlNode.Attributes[NAME_ATTRIBUTE_PDS].InnerText;
                string setToken = xmlNode.Attributes[NAME_ATTRIBUTE_SETTOKEN].InnerText;
                string checkToken = xmlNode.Attributes[NAME_ATTRIBUTE_CHECKTOKEN].InnerText;
                string updateToken = xmlNode.Attributes[NAME_ATTRIBUTE_UPDATETOKEN].InnerText;

                PageElement pageElement = new PageElement(name, path, pds, setToken, checkToken, updateToken);
                Pages.Add(pageElement);
            }
        }

    }
}
