// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.Page
{
    /// <summary>
    /// y[Wݒt@C PageConfiguration ݒ擾܂B
    /// </summary>
    /// <remarks>ɂȂB</remarks>
    public abstract class PageConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(PageConfiguration));

        /// <summary>
        /// dh~@\uvɎw肳Ăy[W`FbN܂B
        /// </summary>
        /// <param name="pagePath">M page ̎ʎqB</param>
        /// <returns>
        /// dh~@\uvɎw肳Ăꍇ true BȊȌꍇ false B
        /// l false łB
        /// </returns>
        /// <remarks>
        /// y[Wݒt@CA<paramref name="pagePath"/> ɑΉ preventDoubleSubmit ̒l擾A
        /// "off" ̏ꍇ true Ԃ܂BȊO false Ԃ܂Bl false łB
        /// </remarks>
        /// <exception cref="System.ArgumentNullException">
        /// <paramref name="pagePath"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.ArgumentException">
        /// <paramref name="pagePath"/> 󕶎łB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂B
        /// </exception>
        public static bool CheckUnAvailablePage(string pagePath)
        {
            if (pagePath == null)
            {
                ArgumentNullException exception = new ArgumentNullException("pagePath");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "pagePath"), exception);
                }
                throw exception;
            }
            if (pagePath.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "pagePath");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            bool ret = false;
            foreach (PageElement pageItem in TerasolunaWebConfiguration.PageConfigSection.Pages)
            {
                if (String.Equals(pagePath, pageItem.Path, StringComparison.CurrentCultureIgnoreCase))
                {
                    //@́@PATH@
                    if ("off".Equals(pageItem.Pds))
                    {
                        //preventDoubleSubmitݒ肪"OFF"(w)łꍇ
                        ret = true;
                    }
                    break;
                }
            }

            if (_log.IsTraceEnabled)
            {
                if (ret)
                {
                    _log.Trace(string.Format(Properties.Resources.T_PREVENT_DOUBLE_SUBMIT_OFF, pagePath));
                }
                else
                {
                    _log.Trace(string.Format(Properties.Resources.T_PREVENT_DOUBLE_SUBMIT_ON, pagePath));
                }
            }

            return ret;
        }

        /// <summary>
        /// w肳ꂽy[WɑΉy[W ID 擾܂B
        /// </summary>
        /// <param name="pagePath">擾y[W ID ̎ʎqB</param>
        /// <returns>
        /// <paramref name="pagePath"/> Ɏw肳ꂽy[WɑΉy[W ID B
        /// Ήy[W ID ݂Ȃꍇ null QƁB
        /// </returns>
        /// <remarks>
        /// y[Wݒt@CA<paramref name="pagePath"/> ̒lɑΉ name ̒l擾܂B
        /// Ή name ̒l݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        /// <exception cref="System.ArgumentNullException">
        /// <paramref name="pagePath"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.ArgumentException">
        /// <paramref name="pagePath"/> 󕶎łB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂łB
        /// </exception>
        public static string GetPageID(string pagePath)
        {
            if (pagePath == null)
            {
                ArgumentNullException exception = new ArgumentNullException("pagePath");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "pagePath"), exception);
                }
                throw exception;
            }
            if (pagePath.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "pagePath");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            string pageID = null;
            foreach (PageElement pageItem in TerasolunaWebConfiguration.PageConfigSection.Pages)
            {
                if (String.Equals(pagePath, pageItem.Path, StringComparison.CurrentCultureIgnoreCase))
                {   //Path pageElement ݂ꍇ
                    PageElement pageElement = TerasolunaWebConfiguration.PageConfigSection.Pages[pageItem.Name];
                    pageID = pageElement.Name;
                    break;
                }
            }

            if (_log.IsTraceEnabled)
            {
                if (pageID == null)
                {
                    _log.Trace(string.Format(Properties.Resources.T_PAGE_CONFIGURATION_NOT_LOAD_PAGE_ID, pagePath));
                }
                else
                {
                    _log.Trace(string.Format(Properties.Resources.T_PAGE_CONFIGURATION_LOAD_PAGE_ID, pagePath, pageID));
                }
            }

            // PagesCollectionɊYpagePath̃GgȂꍇAnullԋp
            return pageID;
        }

        /// <summary>
        /// w肳ꂽy[W ID ɑΉy[W擾܂B
        /// </summary>
        /// <param name="pageID">擾y[W̎ʎqB</param>
        /// <returns>
        /// <paramref name="pageID"/> Ɏw肳ꂽy[W ID ɑΉy[WB
        /// Ήy[W݂Ȃꍇ null QƁB
        /// </returns>
        /// <remarks>
        /// y[Wݒt@CA<paramref name="pageID"/> ̒lɑΉ path ̒l擾܂B
        /// Ή path ̒l݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="pageID"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="pageID"/> 󕶎łB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂łB
        /// </exception>
        public static string GetPath(string pageID)
        {
            if (pageID == null)
            {
                ArgumentNullException exception = new ArgumentNullException("pageID");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "pageID"), exception);
                }
                throw exception;
            }
            if (pageID.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "pageID");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            PageElement pageElement = TerasolunaWebConfiguration.PageConfigSection.Pages[pageID];

            string pagePath = null;
            if (pageElement != null)
            {
                pagePath = pageElement.Path;
            }

            if (_log.IsTraceEnabled)
            {
                if (pagePath == null)
                {
                    _log.Trace(string.Format(Properties.Resources.T_PAGE_CONFIGURATION_NOT_LOAD_PATH, pageID));
                }
                else
                {
                    _log.Trace(string.Format(Properties.Resources.T_PAGE_CONFIGURATION_LOAD_PATH, pageID, pagePath));
                }
            }

            return pagePath;
        }

        /// <summary>
        /// g[N̊mFLǂl擾܂B
        /// </summary>
        /// <param name="pagePath">݂̃y[W̃pXB</param>
        /// <returns>
        /// g[N̊mFLȏꍇ true BLŖꍇ false B
        /// l true łB
        /// </returns>
        /// <remarks>
        /// y[Wݒt@CA<paramref name="pagePath"/> ɑΉ checkToken ̒l擾A
        /// "off" ̏ꍇ false Ԃ܂BȊO true Ԃ܂Bl true łB
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="pagePath"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="pagePath"/> 󕶎łB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂łB
        /// </exception>
        public static bool IsCheckTokenEnabled(string pagePath)
        {
            if (pagePath == null)
            {
                ArgumentNullException exception = new ArgumentNullException("pagePath");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "pagePath"), exception);
                }
                throw exception;
            }
            if (pagePath.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "pagePath");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ftHg̖߂l͗L
            bool ret = true;

            foreach (PageElement pageItem in TerasolunaWebConfiguration.PageConfigSection.Pages)
            {
                if (String.Equals(pagePath, pageItem.Path, StringComparison.CurrentCultureIgnoreCase))
                {
                    //PATH
                    if (String.Equals(pageItem.CheckToken, "off", StringComparison.CurrentCultureIgnoreCase))
                    {
                        //CheckTokenݒ肪"OFF"(w)łꍇ
                        ret = false;
                    }
                    break;
                }
            }

            if (_log.IsTraceEnabled)
            {
                if (ret)
                {
                    _log.Trace(string.Format(Properties.Resources.T_CHECK_TOKEN_ON, pagePath));
                }
                else
                {
                    _log.Trace(string.Format(Properties.Resources.T_CHECK_TOKEN_OFF, pagePath));
                }
            }

            return ret;
        }

        /// <summary>
        /// g[N̔sLǂl擾܂B
        /// </summary>
        /// <param name="pagePath">݂̃y[W̃pXB</param>
        /// <returns>
        /// g[N̔sLȏꍇ true BLŖꍇ false B
        /// l true łB
        /// </returns>
        /// <remarks>
        /// y[Wݒt@CA<paramref name="pagePath"/> ɑΉ setToken ̒l擾A
        /// "off" ̏ꍇ false Ԃ܂BȊO true Ԃ܂Bl true łB
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="pagePath"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="pagePath"/> 󕶎łB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂łB
        /// </exception>
        public static bool IsSetTokenEnabled(string pagePath)
        {
            if (pagePath == null)
            {
                ArgumentNullException exception = new ArgumentNullException("pagePath");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "pagePath"), exception);
                }
                throw exception;
            }
            if (pagePath.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "pagePath");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ftHg̖߂l͗L
            bool ret = true;

            foreach (PageElement pageItem in TerasolunaWebConfiguration.PageConfigSection.Pages)
            {
                if (String.Equals(pagePath, pageItem.Path, StringComparison.CurrentCultureIgnoreCase))
                {
                    //  PATH 
                    if (String.Equals(pageItem.SetToken, "off", StringComparison.CurrentCultureIgnoreCase))
                    {
                        // CheckToken ݒ肪"OFF"(w)łꍇ
                        ret = false;
                    }
                    break;
                }
            }

            if (_log.IsTraceEnabled)
            {
                if (ret)
                {
                    _log.Trace(string.Format(Properties.Resources.T_SET_TOKEN_ON, pagePath));
                }
                else
                {
                    _log.Trace(string.Format(Properties.Resources.T_SET_TOKEN_OFF, pagePath));
                }
            }

            return ret;
        }
        /// <summary>
        /// g[N̍XVLǂl擾܂B
        /// </summary>
        /// <param name="pagePath">݂̃y[W̃pXB</param>
        /// <returns>
        /// g[N̍XVLȏꍇ true BLŖꍇ false B
        /// l true łB
        /// </returns>
        /// <remarks>
        /// y[Wݒt@CA<paramref name="pagePath"/> ɑΉ updateToken ̒l擾A
        /// "off" ̏ꍇ false Ԃ܂BȊO true Ԃ܂Bl true łB<br/>
        ///  updateToken ́At@C_E[h AutoPostBack LȃRg[܂ރy[W
        /// ΂Đݒ肵ĂB
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="pagePath"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="pagePath"/> 󕶎łB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂łB
        /// </exception>
        public static bool IsUpdateTokenEnabled(string pagePath)
        {
            if (pagePath == null)
            {
                ArgumentNullException exception = new ArgumentNullException("pagePath");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "pagePath"), exception);
                }
                throw exception;
            }
            if (pagePath.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "pagePath");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ftHg̖߂l͗L
            bool ret = true;

            foreach (PageElement pageItem in TerasolunaWebConfiguration.PageConfigSection.Pages)
            {
                if (String.Equals(pagePath, pageItem.Path, StringComparison.CurrentCultureIgnoreCase))
                {
                    //  PATH 
                    if (String.Equals(pageItem.UpdateToken, "off", StringComparison.CurrentCultureIgnoreCase))
                    {
                        // UpdateToken ݒ肪"OFF"(XVȂ)łꍇ
                        ret = false;
                    }
                    break;
                }
            }

            if (_log.IsTraceEnabled)
            {
                if (ret)
                {
                    _log.Trace(string.Format(Properties.Resources.T_UPDATE_TOKEN_ON, pagePath));
                }
                else
                {
                    _log.Trace(string.Format(Properties.Resources.T_UPDATE_TOKEN_OFF, pagePath));
                }
            }

            return ret;
        }
    }
}
