﻿// Copyright (c) 2007, NTT DATA Corporation.
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Validation.Validators;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;
namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    /// DoubleRangeValidator のテストクラスです。
    /// </summary>
    [TestClass()]
    public class DoubleRangeValidatorTest
    {


        private TestContext testContextInstance;

        /// <summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        /// </summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest()
        {
            DoubleRangeValidator target =
                new DoubleRangeValidator(-0.1d, RangeBoundaryType.Ignore,
                                      0.1d, RangeBoundaryType.Inclusive,
                                      null,
                                      true);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NEGATED_IG_IN_MESSAGETEMPLATE", placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_DoubleRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_DoubleRangeValidatorAccessor(target);


            Assert.AreEqual<string>(val, accessor.DefaultNegatedMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DoubleRangeValidator), LogLevel.INFO));      
        }

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest()
        {
            DoubleRangeValidator target =
                new DoubleRangeValidator(-0.1d, RangeBoundaryType.Ignore,
                                      0.1d, RangeBoundaryType.Inclusive,
                                      null,
                                      false);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("NUMBER_RANGE_VALIDATOR_NONNEGATED_IG_IN_MESSAGETEMPLATE", placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_DoubleRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_DoubleRangeValidatorAccessor(target);

         Assert.AreEqual<string>(val, accessor.DefaultNonNegatedMessageTemplate, "プロパティの値が不正です");

         //ログ
         Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DoubleRangeValidator), LogLevel.INFO));      
        }
    }
}
