﻿// <著作権>
// Copyright (c) 2007, NTT DATA Corporation.
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    /// ByteRangeValidator のテストクラスです。
    /// </summary>
    [TestClass()]
    public class ByteRangeValidatorTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// DefaultNonNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest01()
        {
            ByteRangeValidator target =
                new ByteRangeValidator(0,10,"shift_jis",null,null,false);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            Assert.AreEqual<string>(val, accessor.DefaultNonNegatedMessageTemplate, "プロパティの値が不正です");
            
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest01()
        {
            ByteRangeValidator target =
                new ByteRangeValidator(0, 10, "shift_jis", null, null, false);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE",placeHolder);

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);

            Assert.AreEqual<string>(val, accessor.DefaultNegatedMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest01()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);

            // 確認
            object objectToValidate = null;// new string[]{"A","B","C"};
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();
            
            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字の場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest02()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+半角カナ文字"である場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest03()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);

            // 確認
            object objectToValidate = "あｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"である場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest04()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);

            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが非文字列の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest05()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor 
                = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);

            // 確認
            object objectToValidate = DateTime.Today;
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target ,"Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));

        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// currentTargetがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest06()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = "オブジェクト";
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.AreEqual(r.Target, "オブジェクト", "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));

        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// currentTargetが非nullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest07()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あｱ";
            object currentTarget = "オブジェクト";
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// keyが非nullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest08()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = "キー";
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.AreEqual<string>(r.Key, "キー", "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));

        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+半角カナ文字"であり、
        /// keyが非nullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest09()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あｱ";
            object currentTarget = null;
            string key = "キー";
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// ValidationResultsがnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest10()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = "キー";
            ValidationResults result = null;

            // 実施
            try{
	            accessor.DoValidate(objectToValidate, currentTarget, key, result);
	            Assert.Fail();
	        }
            catch(TargetInvocationException e)
            {
	            Assert.IsInstanceOfType(e.InnerException , typeof(ArgumentNullException));
	        }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ByteRangeValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "validationResults"));

        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+半角カナ文字"であり、
        /// ValidationResultsがnullの場合、ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest11()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あｱ";
            object currentTarget = null;
            string key = "キー";
            ValidationResults result = null;

            // 実施
            try
            {
                accessor.DoValidate(objectToValidate, currentTarget, key, result);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException));
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ByteRangeValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "validationResults"));

        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// ValidationResultsの検証エラーが1つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest12()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();
            result.AddResult(new ValidationResult("result01", null, null, null, null));


            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };           
            Assert.AreEqual<int>(2, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));

        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+半角カナ文字"であり、
        /// ValidationResultsの検証エラーが1つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest13()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();
            result.AddResult(new ValidationResult("result01", null, null, null, null));

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// validationResultsの検証エラーが3つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest14()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();
            result.AddResult(new ValidationResult("result01", null, null, null, null));
            result.AddResult(new ValidationResult("result02", null, null, null, null));
            result.AddResult(new ValidationResult("result03", null, null, null, null));


            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };
            Assert.AreEqual<int>(4, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r2 = resultList.FindFromMessage("result02");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r3 = resultList.FindFromMessage("result03");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+半角カナ文字"であり、
        /// validationResultsの検証エラーが3つの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest15()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();
            result.AddResult(new ValidationResult("result01", null, null, null, null));
            result.AddResult(new ValidationResult("result02", null, null, null, null));
            result.AddResult(new ValidationResult("result03", null, null, null, null));

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.AreEqual<int>(3, resultList.Count, "エラー数が不正です.");

            ValidationResult r1 = resultList.FindFromMessage("result01");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r2 = resultList.FindFromMessage("result02");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            ValidationResult r3 = resultList.FindFromMessage("result03");
            Assert.IsNull(r1.Key);
            Assert.IsNull(r1.Target);
            Assert.IsNull(r1.Tag);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// プロパティのminLengthが3の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest16()
        {
            // 準備
            int minLength = 3;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);

            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "3", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// プロパティのencodingが"shift_jis"の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest17()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// プロパティのNegatedがtrueの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest18()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, true);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+半角カナ文字"であり、
        /// プロパティのNegatedがtrueの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest19()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, true);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// プロパティのMessageTemplateが空文字の場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest20()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = "";
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// プロパティのMessageTemplateがプレースホルダ0～5の場合、
        /// 検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest21()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = "{0},{1},{2},{3},{4},{5}";
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage("7,,試験対象項目,0,6,utf-8");
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// プロパティのMessageTemplateがプレースホルダ0～7の場合、
        /// FormatExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest22()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = "{0},{1},{2},{3},{4},{5},{6},{7}";
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            try
            {
                accessor.DoValidate(objectToValidate, currentTarget, key, result);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(FormatException));
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+Ascii文字+半角カナ文字"であり、
        /// プロパティのTagがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest23()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = null;

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor 
                = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あAｱ";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "", "0", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが"全角文字+半角カナ文字"であり、
        /// プロパティのTagがnullの場合、検証結果オブジェクトの各プロパティの値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest24()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = null;

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);


            // 確認
            object objectToValidate = "あA";
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsTrue(result.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが非文字列であり、
        /// プロパティのNegatedがtrueの場合、検証結果オブジェクトの
        /// 値が想定値であることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoValidateTest25()
        {
            // 準備
            int minLength = 0;
            int maxLength = 6;
            string encodingName = "utf-8";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, true);
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ByteRangeValidatorAccessor(target);

            // 確認
            object objectToValidate = new object();
            object currentTarget = null;
            string key = null;
            ValidationResults result = new ValidationResults();

            // 実施
            accessor.DoValidate(objectToValidate, currentTarget, key, result);
            ValidationResultList resultList = new ValidationResultList(result);

            // 確認
            Assert.IsFalse(result.IsValid);

            object[] placeHolder = { "{0}", "{1}", "試験対象項目", "0", "6", "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual<string>(r.Tag, "試験対象項目", "Tagが不正です.");
            Assert.IsNull(r.Target, "Targetが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// Encodingプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void EncodingTest01()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Encoding enc = Encoding.GetEncoding("shift_jis");
            Assert.AreEqual<string>(target.Encoding.EncodingName, enc.EncodingName);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// MaxByteLengthプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void MaxByteLengthTest01()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Assert.AreEqual<int>(target.MaxByteLength, maxLength);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// MinByteLengthプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void MinByteLengthTest01()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Assert.AreEqual<int>(target.MinByteLength , minLength);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のminLengthが負の値の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest01()
        {
            // 準備
            int minLength = -3;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            try
            {
                ByteRangeValidator target =
                    new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException), "例外の型が不正です");
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ByteRangeValidator), typeof(ArgumentException), "E_NEGATIVE_NUMBER", "minByteLength"));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のminLengthが正常な値の場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest02()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Assert.AreEqual<int>(target.MaxByteLength, maxLength , "最大byte数が不正です");
            Assert.AreEqual<int>(target.MinByteLength, minLength ,"最小byte数が不正です");

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            Encoding enc = Encoding.GetEncoding(encodingName);
            Assert.AreEqual<string>(target.Encoding.EncodingName, enc.EncodingName,"エンコード種別が不正です");
            Assert.AreEqual<string>(target.MessageTemplate, (MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE",placeHolder)));
            Assert.IsFalse(target.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のminLengthとmaxLengthが同じ値の場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest03()
        {
            // 準備
            int minLength = 3;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Assert.AreEqual<int>(target.MaxByteLength, maxLength, "最大byte数が不正です");
            Assert.AreEqual<int>(target.MinByteLength, minLength, "最小byte数が不正です");
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            Encoding enc = Encoding.GetEncoding(encodingName);
            Assert.AreEqual<string>(target.Encoding.EncodingName, enc.EncodingName, "エンコード種別が不正です");
            Assert.AreEqual<string>(target.MessageTemplate, (MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder)));
            Assert.IsFalse(target.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のmaxLengthが負の値の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest04()
        {
            // 準備
            int minLength = 0;
            int maxLength = -3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));

            // 生成
            try
            {
                ByteRangeValidator target =
                    new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException), "例外の型が不正です");
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のminLengthとmaxLengthが同じ値の場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest05()
        {
            // 準備
            int minLength = 0;
            int maxLength = 0;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Assert.AreEqual<int>(target.MaxByteLength, maxLength, "最大byte数が不正です");
            Assert.AreEqual<int>(target.MinByteLength, minLength, "最小byte数が不正です");
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            Encoding enc = Encoding.GetEncoding(encodingName);
            Assert.AreEqual<string>(target.Encoding.EncodingName, enc.EncodingName, "エンコード種別が不正です");
            Assert.AreEqual<string>(target.MessageTemplate,MessageManager.GetMessage("BYTE_RANGE_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder));
            Assert.IsFalse(target.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のminLengthがmaxLengthより大きな値の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest06()
        {
            // 準備
            int minLength = 3;
            int maxLength = 0;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            try
            {
                ByteRangeValidator target =
                    new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
            }
            catch (Exception e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException), "例外の型が不正です");
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のencodingNameがnullの場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest07()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = null;
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            try
            {
                ByteRangeValidator target =
                    new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
                Assert.Fail();
            }
            catch (Exception e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentNullException), "例外の型が不正です");
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ByteRangeValidator), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "encodingName"));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のencodingNameが空文字の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest08()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            try
            {
                ByteRangeValidator target =
                    new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
                Assert.Fail();
            }
            catch (Exception e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException), "例外の型が不正です");
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ByteRangeValidator), typeof(ArgumentException), "E_EMPTY_STRING", "encodingName"));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のencodingNameが不正なエンコード名の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest09()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "932";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            try
            {
                ByteRangeValidator target =
                    new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);
                Assert.Fail();
            }
            catch (Exception e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException), "例外の型が不正です");
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ByteRangeValidator), typeof(ArgumentException), "E_INVALID_ARGUMENT", "encodingName"));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のmessageTemplateが正常値の場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest10()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = "aaaa";
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Assert.AreEqual<int>(target.MaxByteLength, maxLength, "最大byte数が不正です");
            Assert.AreEqual<int>(target.MinByteLength, minLength, "最小byte数が不正です");

            Encoding enc = Encoding.GetEncoding(encodingName);
            Assert.AreEqual<string>(target.Encoding.EncodingName, enc.EncodingName, "エンコード種別が不正です");
            Assert.AreEqual<string>(target.MessageTemplate, @"aaaa");
            Assert.IsFalse(target.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のtagがnullの場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest11()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = null;

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, false);

            // 確認
            Assert.AreEqual<int>(target.MaxByteLength, maxLength, "最大byte数が不正です");
            Assert.AreEqual<int>(target.MinByteLength, minLength, "最小byte数が不正です");

            Encoding enc = Encoding.GetEncoding(encodingName);
            Assert.AreEqual<string>(target.Encoding.EncodingName, enc.EncodingName, "エンコード種別が不正です");
            Assert.AreEqual<string>(target.MessageTemplate,"\"{2}\" には {3} byte以上 {4} byte以下の長さの文字列を入力してください。");
            Assert.IsFalse(target.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }

        /// <summary>
        /// ByteRangeValidator (int, int, string, string, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のnegatedがtrueの場合、
        /// インスタンスが正常に生成されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ByteRangeValidator_ctorTest12()
        {
            // 準備
            int minLength = 0;
            int maxLength = 3;
            string encodingName = "shift_jis";
            string messageTemplate = null;
            string tag = "試験対象項目";

            // 生成
            ByteRangeValidator target =
                new ByteRangeValidator(minLength, maxLength, encodingName, messageTemplate, tag, true);

            // 確認
            Assert.AreEqual<int>(target.MaxByteLength, maxLength, "最大byte数が不正です");
            Assert.AreEqual<int>(target.MinByteLength, minLength, "最小byte数が不正です");

            Encoding enc = Encoding.GetEncoding(encodingName);
            Assert.AreEqual<string>(target.Encoding.EncodingName, enc.EncodingName, "エンコード種別が不正です");
            Assert.AreEqual<string>(target.MessageTemplate,"\"{2}\" には {3} byte未満または {4} byteより大きい長さの文字列を入力してください。");
            Assert.IsTrue(target.Negated);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ByteRangeValidator), LogLevel.INFO));
        }
    }
}
