using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Common.Configuration;
using System.Collections.Specialized;
using System.Net.Mail;
using System.Text.RegularExpressions;

namespace TERASOLUNA.Fw.CommonUT.Validation.VabValidatorTestData
{
    [ConfigurationElementType(typeof(CustomValidatorData))]
    class DummyValidator05_With1ErrorAnd1NestedError : Validator
    {
        public DummyValidator05_With1ErrorAnd1NestedError(NameValueCollection attributes)
            : base(null, null)
        {
        }

        protected DummyValidator05_With1ErrorAnd1NestedError(string messageTemplate, string tag)
            : base(messageTemplate, tag)
        {
        }

        protected override string DefaultMessageTemplate
        {
            get { return "DummyValidator05_With1ErrorAnd1NestedError_fail"; }
        }

        protected override void DoValidate(object objectToValidate,
                                          object currentTarget,
                                           string key,
                                           ValidationResults validationResults)
        {
            ValidationResult nestedResult1 =
                new ValidationResult("NestedResult01", currentTarget, key, Tag, this);

            List<ValidationResult> nestedResults = new List<ValidationResult>();

            nestedResults.Add(nestedResult1);
            ValidationResult result = 
                new ValidationResult(GetMessage(objectToValidate, key),currentTarget,key,Tag,this,nestedResults);

            validationResults.AddResult(result);
            return;
        }
    }
}
