﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Validation.Validators;
using System.Reflection;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    ///<summary>
    /// DateTimeRangeValidatorExData のテストクラスです。
    ///</summary>
    [TestClass()]
    public class DateTimeRangeValidatorExDataTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化      
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest01()
        {
            //準備
            Type targetType = null;
            DateTime lowerBound = new DateTime(2008, 2, 28);
            DateTime upperBound = new DateTime(2008, 3, 31);
            RangeBoundaryType lowerType = RangeBoundaryType.Inclusive;
            RangeBoundaryType upperType = RangeBoundaryType.Exclusive;
            bool negated = false;
            string messageTemplate = null;
            string tag = "タグ";

            // 初期化
            DateTimeRangeValidatorExData target = new DateTimeRangeValidatorExData();
            target.Negated = negated;
            target.LowerBound = lowerBound;
            target.UpperBound = upperBound;
            target.LowerBoundType = lowerType;
            target.UpperBoundType = upperType;
            target.MessageTemplate = messageTemplate;
            target.Tag = tag;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor(target);

            //実施
            Validator actual = null;
            actual = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(actual);
            Assert.IsInstanceOfType(actual, typeof(DateTimeRangeValidatorEx));
            DateTimeRangeValidatorEx av = (DateTimeRangeValidatorEx)actual;
            Assert.IsFalse(av.Negated);
            Assert.AreEqual<string>(null, av.Tag);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, av.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorExData), LogLevel.INFO));
        }


        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest02()
        {
            //準備
            Type targetType = typeof(IntRangeValidator);
            DateTime lowerBound = new DateTime(2008, 2, 28);
            DateTime upperBound = new DateTime(2008, 3, 31);
            RangeBoundaryType lowerType = RangeBoundaryType.Inclusive;
            RangeBoundaryType upperType = RangeBoundaryType.Exclusive;
            bool negated = false;
            string messageTemplate = null;
            string tag = "タグ";

            // 初期化
            DateTimeRangeValidatorExData target = new DateTimeRangeValidatorExData();
            target.Negated = negated;
            target.LowerBound = lowerBound;
            target.UpperBound = upperBound;
            target.LowerBoundType = lowerType;
            target.UpperBoundType = upperType;
            target.MessageTemplate = messageTemplate;
            target.Tag = tag;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor(target);

            //実施
            Validator actual = null;

            actual = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(actual);
            Assert.IsInstanceOfType(actual, typeof(DateTimeRangeValidatorEx));

            DateTimeRangeValidatorEx av = (DateTimeRangeValidatorEx)actual;
            Assert.IsFalse(av.Negated);
            Assert.AreEqual<string>(null, av.Tag);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, av.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorExData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMessageTemplateが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest08()
        {
            //準備
            Type targetType = null;
            DateTime lowerBound = new DateTime(2008, 2, 28);
            DateTime upperBound = new DateTime(2008, 3, 31);
            RangeBoundaryType lowerType = RangeBoundaryType.Inclusive;
            RangeBoundaryType upperType = RangeBoundaryType.Exclusive;
            bool negated = false;
            string messageTemplate = "test";
            string tag = "タグ";

            // 初期化
            DateTimeRangeValidatorExData target = new DateTimeRangeValidatorExData();
            target.Negated = negated;
            target.LowerBound = lowerBound;
            target.UpperBound = upperBound;
            target.LowerBoundType = lowerType;
            target.UpperBoundType = upperType;
            target.MessageTemplate = messageTemplate;
            target.Tag = tag;
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor(target);

            //実施
            Validator actual = null;

            actual = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(actual);
            Assert.IsInstanceOfType(actual, typeof(DateTimeRangeValidatorEx));
            DateTimeRangeValidatorEx av = (DateTimeRangeValidatorEx)actual;
            Assert.IsFalse(av.Negated);
            Assert.AreEqual<string>(null, av.Tag);
            Assert.AreEqual<string>("test", av.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorExData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのNegatedがtrueの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest09()
        {
            //準備
            Type targetType = null;
            DateTime lowerBound = new DateTime(2008, 2, 28);
            DateTime upperBound = new DateTime(2008, 3, 31);
            RangeBoundaryType lowerType = RangeBoundaryType.Inclusive;
            RangeBoundaryType upperType = RangeBoundaryType.Exclusive;
            bool negated = true;
            string messageTemplate = null;
            string tag = "タグ";

            // 初期化
            DateTimeRangeValidatorExData target = new DateTimeRangeValidatorExData();
            target.Negated = negated;
            target.LowerBound = lowerBound;
            target.UpperBound = upperBound;
            target.LowerBoundType = lowerType;
            target.UpperBoundType = upperType;
            target.MessageTemplate = messageTemplate;
            target.Tag = tag;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor(target);

            //実施
            Validator actual = null;

            actual = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(actual);
            Assert.IsInstanceOfType(actual, typeof(DateTimeRangeValidatorEx));
            DateTimeRangeValidatorEx av = (DateTimeRangeValidatorEx)actual;
            Assert.IsTrue(av.Negated);
            Assert.AreEqual<string>(null, av.Tag);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, av.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorExData), LogLevel.INFO));
        
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのTagがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest10()
        {
            //準備
            Type targetType = null;
            DateTime lowerBound = new DateTime(2008, 2, 28);
            DateTime upperBound = new DateTime(2008, 3, 31);
            RangeBoundaryType lowerType = RangeBoundaryType.Inclusive;
            RangeBoundaryType upperType = RangeBoundaryType.Exclusive;
            bool negated = false;
            string messageTemplate = null;
            string tag = null;

            // 初期化
            DateTimeRangeValidatorExData target = new DateTimeRangeValidatorExData();
            target.Negated = negated;
            target.LowerBound = lowerBound;
            target.UpperBound = upperBound;
            target.LowerBoundType = lowerType;
            target.UpperBoundType = upperType;
            target.MessageTemplate = messageTemplate;
            target.Tag = tag;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor(target);

            //実施
            Validator actual = null;

            actual = accessor.DoCreateValidator(targetType);

            // 確認
            Assert.IsNotNull(actual);
            Assert.IsInstanceOfType(actual, typeof(DateTimeRangeValidatorEx));
            DateTimeRangeValidatorEx av = (DateTimeRangeValidatorEx)actual;
            Assert.IsFalse(av.Negated);
            Assert.AreEqual<string>(null, av.Tag);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATETIME_RANGE_VALIDATOR_NONNEGATED_IN_EX_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, av.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorExData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのLowerBoundTypeとUpperBoundTpeが共にIgnoreの場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest11()
        {
            //準備
            Type targetType = null;
            DateTime lowerBound = new DateTime(2008, 2, 28);
            DateTime upperBound = new DateTime(2008, 3, 31);
            RangeBoundaryType lowerType = RangeBoundaryType.Ignore;
            RangeBoundaryType upperType = RangeBoundaryType.Ignore;
            bool negated = false;
            string messageTemplate = null;
            string tag = "タグ";

            // 初期化
            DateTimeRangeValidatorExData target = new DateTimeRangeValidatorExData();
            target.Negated = negated;
            target.LowerBound = lowerBound;
            target.UpperBound = upperBound;
            target.LowerBoundType = lowerType;
            target.UpperBoundType = upperType;
            target.MessageTemplate = messageTemplate;
            target.Tag = tag;

            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeRangeValidatorExDataAccessor(target);

            //実施
            Validator actual = null;
        
            try
            {
                actual = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (TargetInvocationException e)
            {
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeRangeValidatorExData), LogLevel.INFO));
        }
    }
}
