﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Configuration;
using System.Xml;
using System.Configuration;
using System.IO;
using System.Xml.Schema;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Configuration
{
    /// <summary>
    /// TERASOLUNA.Fw.Common.MergeConfiguration のテスト クラスです。すべての
    /// TERASOLUNA.Fw.Common.MergeConfiguration 単体テストをここに含めます
    /// </summary>
    /// <remarks>
    /// スキーマを使用するテストケースは BLogicSchema.xsd を使用します。
    /// </remarks>
 
    [TestClass()]
    public class MergeConfigurationTest
    {

        private TestContext testContextInstance;
        private const string XML_NAMESPACE = "http://www.terasoluna.jp/schema/BLogicSchema.xsd";
        private const string XML_NAMESPACE_PREFIX = "blogic";
        private const string XML_SCHEMA_FILE_NAME = "TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicSchema.xsd";
        private const string SECTION_NAME = "blogicConfiguration";
        private const string BLOGIC_XPATH = XML_NAMESPACE_PREFIX + ":blogicConfiguration/"
                                                + XML_NAMESPACE_PREFIX + ":blogic";
        private const string BLOGIC_DBINFO_XPATH = BLOGIC_XPATH + "/"
                                                + XML_NAMESPACE_PREFIX + ":dbInfo";
        private const string NAME_ATTRIBUTE_NAME = "name";

        private const string CONFIG_FILE_NAME_01 = "TestItem_MergeConfigSection01.config";
        private const string CONFIG_FILE_NAME_02 = "TestItem_MergeConfigSection02.config";
        private const string CONFIG_FILE_NAME_03 = "TestItem_MergeConfigSection03.config";
        private const string CONFIG_FILE_NAME_04 = "TestItem_MergeConfigSection04.config";
        private const string CONFIG_FILE_NAME_05 = "TestItem_MergeConfigSection05.config";
        private const string CONFIG_FILE_NAME_06 = "TestItem_MergeConfigSection06.config";
        private const string CONFIG_FILE_NAME_07 = "TestItem_MergeConfigSection07.config";
        private const string CONFIG_FILE_NAME_08 = "TestItem_MergeConfigSection08.config";
        private const string CONFIG_FILE_NAME_09 = "TestItem_MergeConfigSection09.config";
        private const string CONFIG_FILE_NAME_10 = "TestItem_MergeConfigSection10.config";
        private const string CONFIG_FILE_NAME_11 = "TestItem_MergeConfigSection11.config";
        private const string CONFIG_FILE_NAME_12 = "TestItem_MergeConfigSection12.config";
        private const string CONFIG_FILE_NAME_13 = "TestItem_MergeConfigSection13.config";
        private const string CONFIG_FILE_NAME_14 = "TestItem_MergeConfigSection14.config";
        private const string CONFIG_FILE_NAME_15 = "TestItem_MergeConfigSection15.config";

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// MergeConfiguration () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            MergeConfiguration target = new MergeConfiguration();
            Assert.IsNotNull(target);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// MergeConfiguration (string, string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, string)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor02()
        {
            string xmlNamespace = XML_NAMESPACE;
            string xmlNameSpacePrefix = XML_NAMESPACE_PREFIX;
            string schemaName = XML_SCHEMA_FILE_NAME;

            MergeConfiguration target = new MergeConfiguration(xmlNamespace, xmlNameSpacePrefix, schemaName);
            Assert.IsNotNull(target);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// MergeConfiguration (string, string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, string)</TestTarget>
        /// <TestCondition>引数xmlNamespaceがNullであること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestConstructor03()
        {
            string xmlNamespace = null;
            string xmlNameSpacePrefix = XML_NAMESPACE_PREFIX;
            string schemaName = XML_SCHEMA_FILE_NAME;

            try
            {
                MergeConfiguration target = new MergeConfiguration(xmlNamespace, xmlNameSpacePrefix, schemaName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("xmlNamespace", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "xmlNamespace"));
        }

        /// <summary>
        /// MergeConfiguration (string, string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, string)</TestTarget>
        /// <TestCondition>引数xmlNamespaceが空文字であること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestConstructor04()
        {
            string xmlNamespace = "";
            string xmlNameSpacePrefix = XML_NAMESPACE_PREFIX;
            string schemaName = XML_SCHEMA_FILE_NAME;

            try
            {
                MergeConfiguration target = new MergeConfiguration(xmlNamespace, xmlNameSpacePrefix, schemaName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(e.Message, MessageManager.GetMessage("E_EMPTY_STRING", "xmlNamespace"));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログ確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "xmlNamespace"));
        }

        /// <summary>
        /// MergeConfiguration (string, string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, string)</TestTarget>
        /// <TestCondition>引数xmlNameSpacePrefixがNullであること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestConstructor05()
        {
            string xmlNamespace = XML_NAMESPACE;
            string xmlNameSpacePrefix = null;
            string schemaName = XML_SCHEMA_FILE_NAME;

            try
            {
                MergeConfiguration target = new MergeConfiguration(xmlNamespace, xmlNameSpacePrefix, schemaName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("xmlNameSpacePrefix", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "xmlNameSpacePrefix"));
        }

        /// <summary>
        /// MergeConfiguration (string, string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, string)</TestTarget>
        /// <TestCondition>引数xmlNameSpacePrefixが空文字であること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestConstructor06()
        {
            string xmlNamespace = XML_NAMESPACE;
            string xmlNameSpacePrefix = "";
            string schemaName = XML_SCHEMA_FILE_NAME;

            try
            {
                MergeConfiguration target = new MergeConfiguration(xmlNamespace, xmlNameSpacePrefix, schemaName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(e.Message, MessageManager.GetMessage("E_EMPTY_STRING", "xmlNameSpacePrefix"));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログ確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "xmlNameSpacePrefix"));
        }
        /// <summary>
        /// MergeConfiguration (string, string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, string)</TestTarget>
        /// <TestCondition>引数schemaNameがNullであること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestConstructor07()
        {
            string xmlNamespace = XML_NAMESPACE;
            string xmlNameSpacePrefix = XML_NAMESPACE_PREFIX;
            string schemaName = null;

            try
            {
                MergeConfiguration target = new MergeConfiguration(xmlNamespace, xmlNameSpacePrefix, schemaName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("schemaName", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "schemaName"));
        }

        /// <summary>
        /// MergeConfiguration (string, string, string) のテスト
        /// </summary>
        /// <TestTarget>Constructor(string, string, string)</TestTarget>
        /// <TestCondition>引数schemaNameが空文字であること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        public void TestConstructor08()
        {
            string xmlNamespace = XML_NAMESPACE;
            string xmlNameSpacePrefix = XML_NAMESPACE_PREFIX;
            string schemaName = "";

            try
            {
                MergeConfiguration target = new MergeConfiguration(xmlNamespace, xmlNameSpacePrefix, schemaName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(e.Message, MessageManager.GetMessage("E_EMPTY_STRING", "schemaName"));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログ確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "schemaName"));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestLoadConfig01()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            target.LoadConfig(sectionName, files);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイルにfile要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection02.config")]
        public void TestLoadConfig02()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_02);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", sectionName), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_INVALID_CUSTOM_SECTION_HANDLER", sectionName));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイルに設定されている外部設定ファイルが存在しないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection03.config")]
        public void TestLoadConfig03()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_03);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(FileNotFoundException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性にファイル名に使用できない文字が含まれていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection04.config")]
        public void TestLoadConfig04()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_04);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;
            string filePath = Environment.CurrentDirectory + @"\TestItem_SqlExternalX>.config";

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(ArgumentException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, filePath), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, filePath));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が260文字以上であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection05.config")]
        public void TestLoadConfig05()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_05);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(PathTooLongException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が無効なパスであること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection06.config")]
        public void TestLoadConfig06()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_06);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(DirectoryNotFoundException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_EXTERNAL_CONFIG_LOAD_FAILED", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>外部設定ファイルがXML形式でないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection07.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal03.config")]
        public void TestLoadConfig07()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_07);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>外部設定ファイルがスキーマ定義に違反していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection08.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal04.config")]
        public void TestLoadConfig08()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_08);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>引数FilesCollectionがnullであること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestLoadConfig09()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = null;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.Equals("files", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "files"));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>外部設定ファイルの設定情報がマージされたXmlDocumentが返却されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestMergeXmlDocument01()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = BLOGIC_XPATH;
            string elementXpath = BLOGIC_DBINFO_XPATH;

            XmlDocument actual;

            actual = target.MergeXmlDocument(sectionXpath, elementXpath);

            XmlNamespaceManager xmlNM = new XmlNamespaceManager(actual.NameTable);
            xmlNM.AddNamespace(XML_NAMESPACE_PREFIX, XML_NAMESPACE);

            Assert.IsNotNull(actual.SelectSingleNode(BLOGIC_DBINFO_XPATH + "[@name='common1']", xmlNM));
            Assert.IsNotNull(actual.SelectSingleNode(BLOGIC_DBINFO_XPATH + "[@name='common2']", xmlNM));
            Assert.IsNotNull(actual.SelectSingleNode(BLOGIC_DBINFO_XPATH + "[@name='common3']", xmlNM));
            Assert.IsNotNull(actual.SelectSingleNode(BLOGIC_DBINFO_XPATH + "[@name='common4']", xmlNM));

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>複数の外部設定ファイルのキー項目が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection09.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal05.config")]
        public void TestMergeXmlDocument02()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_09);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = BLOGIC_XPATH;
            string elementXpath = BLOGIC_XPATH;

            XmlDocument actual;

            try
            {
                actual = target.MergeXmlDocument(sectionXpath, elementXpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
                
                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_INVALID_MERGED_CONFIG", sectionXpath), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_INVALID_MERGED_CONFIG", sectionXpath));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>引数sectionXpathがnullであること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestMergeXmlDocument03()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = null;
            string elementXpath = BLOGIC_DBINFO_XPATH;

            XmlDocument actual;

            try
            {
                actual = target.MergeXmlDocument(sectionXpath, elementXpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("sectionXpath", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "sectionXpath"));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>引数sectionXpathが空文字であること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestMergeXmlDocument04()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = "";
            string elementXpath = BLOGIC_DBINFO_XPATH;

            XmlDocument actual;

            try
            {
                actual = target.MergeXmlDocument(sectionXpath, elementXpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "sectionXpath"), e.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "sectionXpath"));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>引数elementXpathがnullであること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestMergeXmlDocument05()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = BLOGIC_XPATH;
            string elementXpath = null;

            XmlDocument actual;

            try
            {
                actual = target.MergeXmlDocument(sectionXpath, elementXpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("elementXpath", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "elementXpath"));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>引数elementXpathが空文字であること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestMergeXmlDocument06()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = BLOGIC_XPATH;
            string elementXpath = "";

            XmlDocument actual;

            try
            {
                actual = target.MergeXmlDocument(sectionXpath, elementXpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "elementXpath"), e.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "elementXpath"));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>sectionNameに空文字を指定すること</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestLoadConfig10()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = "";
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "sectionName"), e.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_EMPTY_STRING", "sectionName"));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>sectionNameにnull指定すること</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestLoadConfig11()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = null;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                Assert.AreEqual("sectionName", e.ParamName);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "sectionName"));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>sectionNameに該当しない値を指定すること</TestCondition>
        /// <TestAssertion>例外がスローされないこと。Nullが帰ること。</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestLoadConfig12()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = "hoge";
            FilesCollection files = section.Files;

            target.LoadConfig(sectionName, files);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルapplicationTransition要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection11.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal07.config")]
        public void TestLoadConfig13()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_11);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイル不正な要素があること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection12.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal08.config")]
        public void TestLoadConfig14()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_12);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// LoadConfig (string, FilesCollection) のテスト
        /// </summary>
        /// <TestTarget>LoadConfig (string, FilesCollection)</TestTarget>
        /// <TestCondition>構成ファイル、ResultID属性が重複すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection13.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal09.config")]
        public void TestLoadConfig15()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_13);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);

            string sectionName = SECTION_NAME;
            FilesCollection files = section.Files;

            try
            {
                target.LoadConfig(sectionName, files);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
                Assert.AreEqual(MessageManager.GetMessage("E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)), ex.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ConfigurationErrorsException), "E_CONFIGURATION_INVALID_EXTERNAL_CONFIG_FILE", sectionName, Path.Combine(AppDomain.CurrentDomain.BaseDirectory, files[0].Path)));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>第一引数が適切な指定でない場合</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされる</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestMergeXmlDocument12()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = "hoge";
            string elementXpath = BLOGIC_DBINFO_XPATH;

            XmlDocument actual;

            try
            {
                actual = target.MergeXmlDocument(sectionXpath, elementXpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_ARGUMENT", "sectionXpath"), e.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_INVALID_ARGUMENT", "sectionXpath"));
        }

        /// <summary>
        /// MergeXmlDocument (string, string) のテスト
        /// </summary>
        /// <TestTarget>MergeXmlDocument (string, string)</TestTarget>
        /// <TestCondition>第二引数が適切な指定でない場合</TestCondition>
        /// <TestAssertion>ArgumentExceptionがスローされる</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        [DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        public void TestMergeXmlDocument13()
        {
            BLogicConfigurationSection section =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
            MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            target.LoadConfig(SECTION_NAME, section.Files);

            string sectionXpath = BLOGIC_XPATH;
            string elementXpath = "hoge";

            XmlDocument actual;

            try
            {
                actual = target.MergeXmlDocument(sectionXpath, elementXpath);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // インスタンス生成確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);

                // メッセージ確認
                Assert.AreEqual(MessageManager.GetMessage("E_INVALID_ARGUMENT", "elementXpath"), e.Message);
            }

            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MergeConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MergeConfiguration), typeof(ArgumentException), "E_INVALID_ARGUMENT", "elementXpath"));
        }

        ///// <summary>
        ///// MergeWithChildDocument (string, string, string) のテスト
        ///// </summary>
        ///// <TestTarget>MergeWithChildDocument (string, string, string)</TestTarget>
        ///// <TestCondition>第一引数が適切な指定でない場合</TestCondition>
        ///// <TestAssertion>ArgumentExceptionがスローされる</TestAssertion>
        //[TestMethod()]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        //public void TestMergeWithChildDocument09()
        //{
        //    BLogicConfigurationSection section =
        //        ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
        //    MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
        //    target.LoadConfig(SECTION_NAME, section.Files);
        //    target.MergeXmlDocument(BLOGIC_XPATH, BLOGIC_DBINFO_XPATH);

        //    string sectionXpath = "hoge";
        //    string elementXpath = BLOGIC_DBINFO_XPATH;
        //    string attributeName = NAME_ATTRIBUTE_NAME;

        //    XmlDocument actual;

        //    try
        //    {
        //        actual = target.MergeWithChildDocument(sectionXpath, elementXpath, attributeName);
        //        Assert.Fail("到達してはいけないコードです。");
        //    }
        //    catch (ArgumentException)
        //    {
        //        Assert.IsTrue(true);
        //    }

        //}

        ///// <summary>
        ///// MergeWithChildDocument (string, string, string) のテスト
        ///// </summary>
        ///// <TestTarget>MergeWithChildDocument (string, string, string)</TestTarget>
        ///// <TestCondition>第二引数が適切な指定でない場合</TestCondition>
        ///// <TestAssertion>ArgumentExceptionがスローされる</TestAssertion>
        //[TestMethod()]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        //public void TestMergeWithChildDocument10()
        //{
        //    BLogicConfigurationSection section =
        //        ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
        //    MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
        //    target.LoadConfig(SECTION_NAME, section.Files);
        //    target.MergeXmlDocument(BLOGIC_XPATH, BLOGIC_DBINFO_XPATH);

        //    string sectionXpath = BLOGIC_XPATH;
        //    string elementXpath = "hoge";
        //    string attributeName = NAME_ATTRIBUTE_NAME;

        //    XmlDocument actual;


        //    try
        //    {
        //        actual = target.MergeWithChildDocument(sectionXpath, elementXpath, attributeName);
        //        Assert.Fail("到達してはいけないコードです。");
        //    }
        //    catch (ArgumentException)
        //    {
        //        Assert.IsTrue(true);
        //    }

        //}

        ///// <summary>
        ///// MergeWithChildDocument (string, string, string) のテスト
        ///// </summary>
        ///// <TestTarget>MergeWithChildDocument (string, string, string)</TestTarget>
        ///// <TestCondition>第三引数が適切な指定でない場合</TestCondition>
        ///// <TestAssertion>ArgumentExceptionがスローされる</TestAssertion>
        //[TestMethod()]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigSection01.config")]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigExternal01.config")]
        //[DeploymentItem(@"Configuration\TestItem_MergeConfigExternal02.config")]
        //public void TestMergeWithChildDocument11()
        //{
        //    BLogicConfigurationSection section =
        //        ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);
        //    MergeConfiguration target = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
        //    target.LoadConfig(SECTION_NAME, section.Files);
        //    target.MergeXmlDocument(BLOGIC_XPATH, BLOGIC_DBINFO_XPATH);

        //    string sectionXpath = BLOGIC_XPATH;
        //    string elementXpath = BLOGIC_DBINFO_XPATH;
        //    string attributeName = "hoge";

        //    XmlDocument actual;


        //    try
        //    {
        //        actual = target.MergeWithChildDocument(sectionXpath, elementXpath, attributeName);
        //        Assert.Fail("到達してはいけないコードです。");
        //    }
        //    catch (ArgumentException)
        //    {
        //        Assert.IsTrue(true);
        //    }

        //}

    }


}
