﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Configuration;
using TERASOLUNA.Fw.Common.Configuration.BLogic;

namespace TERASOLUNA.Fw.CommonUT.Configuration
{
    /// <summary>
    /// 設定情報取得機能のテストに使用するヘルパークラス。
    /// </summary>
    /// <remarks>
    /// </remarks>
   
    class ConfigTestHelper
    {

        /// <summary>
        /// 指定した構成ファイルを使用して、構成セクションを取得します。
        /// </summary>
        /// <remarks>
        /// </remarks>
        /// <param name="sectionName">取得するセクション名。</param>
        /// <param name="configFileName">構成ファイルのファイル名。</param>
        /// <returns>引数に指定した構成ファイルから取得したセクションハンドラ。</returns>
        private static ConfigurationSection GetSectionFromCustomFile(string sectionName, string configFileName)
        {
            ExeConfigurationFileMap fileMap = new ExeConfigurationFileMap();
            fileMap.ExeConfigFilename = configFileName;
            System.Configuration.Configuration conf = ConfigurationManager.OpenMappedExeConfiguration(fileMap, ConfigurationUserLevel.None);
            return conf.GetSection(sectionName);
        }

        /// <summary>
        /// 指定した構成ファイルを使用して、<see cref="TERASOLUNA.Fw.Common.Configuration.BLogicConfiguration.BLogicConfigurationSection" />を取得します。
        /// </summary>
        /// <param name="configFileName">構成ファイルのファイル名。</param>
        /// <returns>引数に指定した構成ファイルから取得した<see cref="TERASOLUNA.Fw.Common.Configuration.BLogicConfigurationSection" /></returns>
        public static BLogicConfigurationSection GetBLogicConfigurationSectionFromCustomFile(string configFileName)
        {
            return (BLogicConfigurationSection)GetSectionFromCustomFile("blogicConfiguration", configFileName);
        }

        ///// <summary>
        ///// 指定した構成ファイルを使用して、<see cref="TERASOLUNA.Fw.Common.Configuration.ConversionConfiguration.ConversionConfigurationSection" />を取得します。
        ///// </summary>
        ///// <param name="configFileName">構成ファイルのファイル名。</param>
        ///// <returns>引数に指定した構成ファイルから取得したConversionConfigurationSection。</returns>
        //public static ConversionConfigurationSection GetConversionConfigurationSectionFromCustomFile(string configFileName)
        //{
        //    return (ConversionConfigurationSection)GetSectionFromCustomFile("conversionConfiguration", configFileName);
        //}

        ///// <summary>
        ///// 指定した構成ファイルを使用して、<see cref="TERASOLUNA.Fw.Common.Configuration.ViewConfiguration.ViewConfigurationSection" />を取得します。
        ///// </summary>
        ///// <param name="configFileName">構成ファイルのファイル名。</param>
        ///// <returns>引数に指定した構成ファイルから取得したViewConfigurationSection。</returns>
        //public static ViewConfigurationSection GetViewConfigurationSectionFromCustomFile(string configFileName)
        //{
        //    return (ViewConfigurationSection)GetSectionFromCustomFile("viewConfiguration", configFileName);
        //}
    }
}
