// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.BLogic;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    public class Coordinator_BLogicFactoryStub01 : BLogicFactory
    {
        public static IBLogic _blogic = null;
        public static string _blogicName = null;
        public static string[] _genericTypeNames = null;
        public static bool _isCalledCreateInstance = false;

        protected override IBLogic CreateInstance(string blogicName, params string[] genericTypeNames)
        {
            _blogicName = blogicName;
            _genericTypeNames = genericTypeNames;
            _isCalledCreateInstance = true;

            return _blogic;
        }

        public static void Initialize()
        {
            _blogic = null;
            _blogicName = null;
            _genericTypeNames = null;
            _isCalledCreateInstance = false;
        }

    }
}
