// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Configuration.View;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.ClientUT.Configuration.View
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Configuration.View.ViewElement のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Configuration.View.ViewElement 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ViewElementTest
    {


        private TestContext testContextInstance;

        ///<summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        ///<summary>
        /// Id のテスト
        ///</summary>
        ///<remarks>
        /// コンストラクタに設定したIdが正しく取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void IdTest01()
        {
            // 準備
            string expectedId = "View1";

            // 実行
            ViewElement target = new ViewElement(string.Empty, expectedId);
            string actual = target.Id;

            // 検証
            Assert.AreEqual(expectedId, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ViewElement), LogLevel.INFO));

        }

        ///<summary>
        /// Type のテスト
        ///</summary>
        ///<remarks>
        /// コンストラクタに設定したTypeが正しく取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void TypeTest01()
        {
            // 準備
            string expectedType = "View1.Class";

            // 実行
            ViewElement target = new ViewElement(expectedType, null);
            string actual = target.Type;

            // 検証
            Assert.AreEqual(expectedType, actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ViewElement), LogLevel.INFO));

        }

        /// <summary>
        ///ViewElement () のテスト
        ///</summary>
        /// <remarks>
        /// デフォルトコンストラクタが正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            ViewElement target = new ViewElement();
            Assert.IsNotNull(target);
            Assert.AreEqual(string.Empty, target.Id);
            Assert.AreEqual(string.Empty, target.Type);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ViewElement), LogLevel.INFO));

        }

        /// <summary>
        /// ViewElement (string, string) のテスト
        /// </summary>
        /// <remarks>
        /// id、typeに正常値を入力した場合に正しく値を保持したインスタンスが作成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringStringTest01()
        {
            // 準備
            string expectedId = "View1";
            string expectedType = "View1.Class1 View1";

            // 実行
            ViewElement target = new ViewElement(expectedType, expectedId);
            string actualId = target.Id;
            string actualType = target.Type;

            // 検証
            Assert.IsNotNull(target);
            Assert.AreEqual(expectedId, actualId);
            Assert.AreEqual(expectedType, actualType);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ViewElement), LogLevel.INFO));
        }
    }
}
