// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.BLogic;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.ClientUT.BLogic.BinaryFileDownloadBLogicData;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.ClientUT.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.BLogic.BinaryFileDownloadBLogic のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.BLogic.BinaryFileDownloadBLogic 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class BinaryFileDownloadBLogicTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///CreateCommunicator () のテスト
        ///</summary>
        [TestMethod()]
        public void CreateCommunicatorTest()
        {
            BinaryFileDownloadBLogic target = new BinaryFileDownloadBLogic();
            TERASOLUNA_Fw_Client_BLogic_BinaryFileDownloadBLogicAccessor accessor = new TERASOLUNA_Fw_Client_BLogic_BinaryFileDownloadBLogicAccessor(target);

            ICommunicator<DataSet> actual = accessor.CreateCommunicator();

            Assert.IsInstanceOfType(actual, typeof(BinaryFileDownloadCommunicator));
        }

        /// <summary>
        /// Execute (BLogicParam) のテスト
        /// </summary>
        /// <remarks>
        /// BinaryFileDownloadCommunicator の戻り値 DownliadFilePath が null の場合、正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest01()
        {
            // 準備
            BinaryFileDownloadBLogicStub01 target = new BinaryFileDownloadBLogicStub01();

            BLogicParam blogicParam = new BLogicParam();
            DataSet paramData = new DataSet();
            blogicParam.ParamData = paramData;
            blogicParam.Items.Add("RequestName", "binaryFileDownloadBLogic");

            // 実施
            BLogicResult blogicResult = target.Execute(blogicParam);

            // 確認
            BinaryFileDownloadBLogic_BinaryFileDownloadCommunicatorStub01 expectedCommunicator = target._communicator;
            DataSet expectedResultData = expectedCommunicator._resultDataSet;

            Assert.AreSame(paramData, expectedCommunicator._paramData);
            Assert.AreEqual(1, expectedCommunicator._requestHeaders.Count);
            Assert.AreEqual("binaryFileDownloadBLogic", expectedCommunicator._requestHeaders["RequestName"]);

            Assert.AreEqual(BLogicResult.SUCCESS, blogicResult.ResultString);
            Assert.AreSame(expectedResultData, blogicResult.ResultData);
            Assert.AreEqual(0, blogicResult.Errors.Count);
            Assert.AreEqual(0, blogicResult.Items.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BinaryFileDownloadBLogic), LogLevel.INFO));
        }

        /// <summary>
        /// Execute (BLogicParam) のテスト
        /// </summary>
        /// <remarks>
        /// BinaryFileDownloadCommunicator の戻り値 DownliadFilePath が空文字列の場合、正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest02()
        {
            // 準備
            BinaryFileDownloadBLogicStub02 target = new BinaryFileDownloadBLogicStub02();

            BLogicParam blogicParam = new BLogicParam();
            DataSet paramData = new DataSet();
            blogicParam.ParamData = paramData;
            blogicParam.Items.Add("RequestName", "binaryFileDownloadBLogic");

            // 実施
            BLogicResult blogicResult = target.Execute(blogicParam);

            // 確認
            BinaryFileDownloadBLogic_BinaryFileDownloadCommunicatorStub01 expectedCommunicator = target._communicator;
            DataSet expectedResultData = expectedCommunicator._resultDataSet;

            Assert.AreSame(paramData, expectedCommunicator._paramData);
            Assert.AreEqual(1, expectedCommunicator._requestHeaders.Count);
            Assert.AreEqual("binaryFileDownloadBLogic", expectedCommunicator._requestHeaders["RequestName"]);

            Assert.AreEqual(BLogicResult.SUCCESS, blogicResult.ResultString);
            Assert.AreSame(expectedResultData, blogicResult.ResultData);
            Assert.AreEqual(0, blogicResult.Errors.Count);
            Assert.AreEqual(0, blogicResult.Items.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BinaryFileDownloadBLogic), LogLevel.INFO));
        }

        /// <summary>
        /// Execute (BLogicParam) のテスト
        /// </summary>
        /// <remarks>
        /// BinaryFileDownloadCommunicator の戻り値 DownliadFilePath が null または空文字列以外の場合、
        /// 正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest03()
        {
            // 準備
            BinaryFileDownloadBLogicStub03 target = new BinaryFileDownloadBLogicStub03();

            BLogicParam blogicParam = new BLogicParam();
            DataSet paramData = new DataSet();
            blogicParam.ParamData = paramData;
            blogicParam.Items.Add("RequestName", "binaryFileDownloadBLogic");

            // 実施
            BLogicResult blogicResult = target.Execute(blogicParam);

            // 確認
            BinaryFileDownloadBLogic_BinaryFileDownloadCommunicatorStub01 expectedCommunicator = target._communicator;
            DataSet expectedResultData = expectedCommunicator._resultDataSet;

            Assert.AreSame(paramData, expectedCommunicator._paramData);
            Assert.AreEqual(1, expectedCommunicator._requestHeaders.Count);
            Assert.AreEqual("binaryFileDownloadBLogic", expectedCommunicator._requestHeaders["RequestName"]);

            Assert.AreEqual(BLogicResult.SUCCESS, blogicResult.ResultString);
            Assert.AreSame(expectedResultData, blogicResult.ResultData);
            Assert.AreEqual(0, blogicResult.Errors.Count);
            Assert.AreEqual(1, blogicResult.Items.Count);
            string actualDownloadFilePath = blogicResult.Items[BinaryFileDownloadBLogic.DOWNLOAD_FILEPATH] as string;
            Assert.AreEqual("terasoluna.bmp", actualDownloadFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BinaryFileDownloadBLogic), LogLevel.INFO));
        }

        /// <summary>
        /// Execute (BLogicParam) のテスト
        /// </summary>
        /// <remarks>
        /// BinaryFileDownloadCommunicator で ArgumentException が発生した時に、
        /// そのまま ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest04()
        {
            // 準備
            BinaryFileDownloadBLogicStub04 target = new BinaryFileDownloadBLogicStub04();

            BLogicParam blogicParam = new BLogicParam();
            DataSet paramData = new DataSet();
            blogicParam.ParamData = paramData;
            blogicParam.Items.Add("RequestName", "binaryFileDownloadBLogic");

            // 実施
            try
            {
                BLogicResult blogicResult = target.Execute(blogicParam);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual("BinaryFileDownloadException", e.Message);
            }

            // 確認
            BinaryFileDownloadBLogic_BinaryFileDownloadCommunicatorStub02 expectedCommunicator = target._communicator;
            Assert.AreSame(paramData, expectedCommunicator._paramData);
            Assert.AreEqual(1, expectedCommunicator._requestHeaders.Count);
            Assert.AreEqual("binaryFileDownloadBLogic", expectedCommunicator._requestHeaders["RequestName"]);

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BinaryFileDownloadBLogic), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckWarnUseMessageId(typeof(CommunicateBLogicBase<DataSet>), typeof(ArgumentException), "W_BLOGIC_EXCEPTION"));
        }

        /// <summary>
        /// Execute (BLogicParam) のテスト
        /// </summary>
        /// <remarks>
        /// BinaryFileDownloadCommunicator で ServerException が発生した時に、ErrorType が "serverException" の場合は
        /// そのまま ArgumentException がスローされることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest05()
        {
            // 準備
            BinaryFileDownloadBLogicStub05 target = new BinaryFileDownloadBLogicStub05();

            BLogicParam blogicParam = new BLogicParam();
            DataSet paramData = new DataSet();
            blogicParam.ParamData = paramData;
            blogicParam.Items.Add("RequestName", "binaryFileDownloadBLogic");

            // 実施
            try
            {
                BLogicResult blogicResult = target.Execute(blogicParam);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ServerException e)
            {
                Assert.AreEqual("BinaryFileDownloadException", e.Message);
                Assert.AreEqual(ReceiverBase.SERVER_EXCEPTION, e.ErrorType);
            }

            // 確認
            BinaryFileDownloadBLogic_BinaryFileDownloadCommunicatorStub03 expectedCommunicator = target._communicator;
            Assert.AreSame(paramData, expectedCommunicator._paramData);
            Assert.AreEqual(1, expectedCommunicator._requestHeaders.Count);
            Assert.AreEqual("binaryFileDownloadBLogic", expectedCommunicator._requestHeaders["RequestName"]);

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BinaryFileDownloadBLogic), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckWarnUseMessageId(typeof(CommunicateBLogicBase<DataSet>), typeof(ServerException), "W_BLOGIC_EXCEPTION"));
        }

        /// <summary>
        /// Execute (BLogicParam) のテスト
        /// </summary>
        /// <remarks>
        /// BinaryFileDownloadCommunicator で ServerException が発生した時に、ErrorType が "serverValidateException" の場合は
        /// 正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest06()
        {
            // 準備
            BinaryFileDownloadBLogicStub06 target = new BinaryFileDownloadBLogicStub06();

            BLogicParam blogicParam = new BLogicParam();
            DataSet paramData = new DataSet();
            blogicParam.ParamData = paramData;
            blogicParam.Items.Add("RequestName", "binaryFileDownloadBLogic");

            // 実施
            BLogicResult blogicResult = target.Execute(blogicParam);

            // 確認
            BinaryFileDownloadBLogic_BinaryFileDownloadCommunicatorStub04 expectedCommunicator = target._communicator;
            Assert.AreSame(paramData, expectedCommunicator._paramData);
            Assert.AreEqual(1, expectedCommunicator._requestHeaders.Count);
            Assert.AreEqual("binaryFileDownloadBLogic", expectedCommunicator._requestHeaders["RequestName"]);

            Assert.AreEqual(ReceiverBase.SERVER_VALIDATE_EXCEPTION, blogicResult.ResultString);
            Assert.IsNull(blogicResult.ResultData);
            Assert.AreEqual(1, blogicResult.Errors.Count);
            Assert.AreEqual("key01", blogicResult.Errors[0].Key);
            Assert.AreEqual("value01", blogicResult.Errors[0].Message);
            Assert.AreEqual(0, blogicResult.Items.Count);

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BinaryFileDownloadBLogic), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckWarnUseMessageId(typeof(CommunicateBLogicBase<DataSet>), typeof(ServerException), "W_BLOGIC_EXCEPTION"));
        }

        /// <summary>
        /// Execute (BLogicParam) のテスト
        /// </summary>
        /// <remarks>
        /// BinaryFileDownloadCommunicator で CommunicationException が発生した時に、
        /// 正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest07()
        {
            // 準備
            BinaryFileDownloadBLogicStub07 target = new BinaryFileDownloadBLogicStub07();

            BLogicParam blogicParam = new BLogicParam();
            DataSet paramData = new DataSet();
            blogicParam.ParamData = paramData;
            blogicParam.Items.Add("RequestName", "binaryFileDownloadBLogic");

            // 実施
            BLogicResult blogicResult = target.Execute(blogicParam);

            // 確認
            BinaryFileDownloadBLogic_BinaryFileDownloadCommunicatorStub05 expectedCommunicator = target._communicator;
            Assert.AreSame(paramData, expectedCommunicator._paramData);
            Assert.AreEqual(1, expectedCommunicator._requestHeaders.Count);
            Assert.AreEqual("binaryFileDownloadBLogic", expectedCommunicator._requestHeaders["RequestName"]);

            Assert.AreEqual(CommunicateBLogicBase<DataSet>.COMMUNICATION_EXCEPTION, blogicResult.ResultString);
            Assert.IsNull(blogicResult.ResultData);
            Assert.AreEqual(1, blogicResult.Errors.Count);
            Assert.AreEqual(CommunicateBLogicBase<DataSet>.COMMUNICATION_EXCEPTION, blogicResult.Errors[0].Key);
            Assert.AreEqual("BinaryFileDownloadException", blogicResult.Errors[0].Message);
            Assert.AreEqual(0, blogicResult.Items.Count);

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(CommunicateBLogicBase<DataSet>), LogLevel.INFO));
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BinaryFileDownloadBLogic), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckWarnUseMessageId(typeof(CommunicateBLogicBase<DataSet>), typeof(CommunicationException), "W_BLOGIC_EXCEPTION"));
        }
    }
}
