// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.Configuration.View
{
    /// <summary>
    /// view vf̃RNVi[\vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ViewCollection"/> ́AʑJڐݒt@C view vf̃RNV
    /// \܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElementCollection"/> QƂĂB
    /// </remarks>
    public class ViewCollection : ConfigurationElementCollection
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ViewCollection));

        /// <summary>
        /// view vf̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "view" łB
        /// </remarks>
        private static readonly string FORWARDABLE_ELEMENT_NAME = "view";

        /// <summary>
        /// <see cref="ViewCollection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB
        /// </remarks>
        public ViewCollection()
        {
        }

        /// <summary>
        /// <see cref="ViewCollection"/> ̌^擾܂B
        /// </summary>
        /// <remarks>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/>  BasicMap łB
        /// </remarks>
        /// <value>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/> B
        /// </value>
        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.BasicMap;
            }
        }

        /// <summary>
        /// V view vf쐬܂B
        /// </summary>
        /// <returns>V view vfB</returns>
        /// <remarks>
        /// V <see cref="ViewElement"/> NX̃CX^X쐬܂B
        /// </remarks>
        protected override ConfigurationElement CreateNewElement()
        {
            return new ViewElement();
        }

        /// <summary>
        /// w肵CfbNXʒuɂ view vf擾܂B
        /// </summary>
        /// <param name="index">擾 ViewElement ̃CfbNXʒuB</param>
        /// <returns>w肵CfbNXʒuɂ <see cref="ViewElement"/> B</returns>
        /// <remarks>
        /// <see cref="ConfigurationElementCollection.BaseGet(int)"/> \bhgpāA
        /// <see cref="ViewCollection"/>  <see cref="ViewElement"/> 擾܂B
        /// </remarks>
        public ViewElement this[int index]
        {
            get
            {
                return (ViewElement)BaseGet(index);
            }
        }

        /// <summary>
        /// w肵L[ view vf擾܂B
        /// </summary>
        /// <param name="name">擾 view vf̃L[B</param>
        /// <returns>w肵L[ <see cref="ViewElement"/> BȊȌꍇ null QƁB
        /// </returns>
        /// <remarks>
        /// <see cref="ConfigurationElementCollection.BaseGet(object)"/> \bhgpāA
        /// <see cref="ViewCollection"/>  <see cref="ViewElement"/> 擾
        /// ܂Bw肵L[ <see cref="ViewElement"/> RNV
        /// ݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        public new ViewElement this[string name]
        {
            get
            {
                return (ViewElement)BaseGet(name);
            }
        }

        /// <summary>
        /// ʑJڐݒt@Ĉ̗vf̃RNVʂ邽߂Ɏgp
        /// O擾܂B
        /// </summary>
        /// <remarks>
        /// vf view łB
        /// </remarks>
        /// <value>
        /// ̗vf̃RNV̗vfB
        /// </value>
        protected override string ElementName
        {
            get
            {
                return FORWARDABLE_ELEMENT_NAME;
            }
        }

        /// <summary>
        /// view vf̗vfL[擾܂B
        /// </summary>
        /// <param name="element">擾 <see cref="ViewElement"/> vf̃L[B</param>
        /// <returns>w肵L[ <see cref="ViewElement"/> BȊȌꍇ null QƁB
        /// </returns>
        /// <exception cref="System.ArgumentNullException"><paramref name="element"/>  null ̏ꍇB</exception>
        /// <exception cref="System.ArgumentException"><paramref name="element"/>  
        /// <see cref="ViewElement"/> ł͂ȂꍇB</exception>
        protected override Object GetElementKey(ConfigurationElement element)
        {
            if (element == null)
            {
                ArgumentNullException exception = new ArgumentNullException("element");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Client.Properties.Resources.E_NULL_ARGUMENT, "element"), exception);
                }
                throw exception;
            }
            ViewElement viewElement = element as ViewElement;
            if (viewElement == null)
            {
                string message = string.Format(
                    TERASOLUNA.Fw.Client.Properties.Resources.E_INVALID_CAST,
                    element.GetType().FullName, typeof(ViewElement).FullName);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return viewElement.Id;
        }

        /// <summary>
        /// <see cref="ViewCollection"/>  view vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="ViewElement"/> B</param>
        /// <remarks>
        /// <see cref="ViewCollection.BaseAdd(ConfigurationElement)"/> \bhgpāA
        /// RNVɐV <see cref="ViewElement"/> ǉ܂B
        /// </remarks>
        public void Add(ViewElement element)
        {
            BaseAdd(element);
        }

        /// <summary>
        /// <see cref="ViewCollection"/>  view vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="ViewElement"/> B</param>
        /// <remarks>
        /// w肵 <paramref name="element"/>  view vfRNVɊɑ݂ꍇA
        /// O͔܂B
        /// </remarks>
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        /// <summary>
        /// <see cref="ViewCollection"/> ǂݎpǂl擾܂B 
        /// </summary>
        /// <returns>
        /// <see cref="ViewCollection"/> ǂݎp̏ꍇ true BȊȌꍇ false B
        /// </returns>
        /// <remarks>
        /// <see cref="ViewCollection"/> ͓ǂݎpł͂܂B
        /// </remarks>
        public override bool IsReadOnly()
        {
            return false;
        }
    }
}
