// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Web.Configuration.Sql;
using TERASOLUNA.Fw.Web.Configuration.Page;
using TERASOLUNA.Fw.Web.Configuration.ExceptionTransition;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Web.Configuration.RequestController;
using TERASOLUNA.Fw.Web.Configuration.ExceptionCode;

namespace TERASOLUNA.Fw.WebUT.Configuration
{
    /// <summary>
    /// ݒ擾@\̃eXgɎgpwp[NXB
    /// </summary>
    /// <remarks>
    /// </remarks>

    class ConfigTestHelper
    {

        /// <summary>
        /// w肵\t@CgpāA\ZNV擾܂B
        /// </summary>
        /// <remarks>
        /// </remarks>
        /// <param name="sectionName">擾ZNVB</param>
        /// <param name="configFileName">\t@C̃t@CB</param>
        /// <returns>Ɏw肵\t@C擾ZNVnhB</returns>
        private static ConfigurationSection GetSectionFromCustomFile(string sectionName, string configFileName)
        {
            ExeConfigurationFileMap fileMap = new ExeConfigurationFileMap();
            fileMap.ExeConfigFilename = configFileName;
            System.Configuration.Configuration conf = ConfigurationManager.OpenMappedExeConfiguration(fileMap, ConfigurationUserLevel.None);
            return conf.GetSection(sectionName);
        }

        /// <summary>
        /// w肵\t@CgpāA<see cref="TERASOLUNA.Fw.Common.Configuration.SqlConfigurationSection" />擾܂B
        /// </summary>
        /// <param name="configFileName">\t@C̃t@CB</param>
        /// <returns>Ɏw肵\t@C擾SqlConfigurationSectionB</returns>
        public static SqlConfigurationSection GetSqlConfigurationSectionFromCustomFile(string configFileName)
        {
            return (SqlConfigurationSection)GetSectionFromCustomFile("sqlConfiguration", configFileName);
        }

        /// <summary>
        /// w肵\t@CgpāAPreventDoubleSubmissionConfigurationSection擾܂B
        /// </summary>
        /// <param name="configFileName">\t@C̃t@CB</param>
        /// <returns>Ɏw肵\t@C擾GetPageConfigurationSectionFromCustomFileB</returns>
        public static PageConfigurationSection GetPageConfigurationSectionFromCustomFile(string configFileName)
        {
            return (PageConfigurationSection)GetSectionFromCustomFile("pageConfiguration", configFileName);
        }

        /// <summary>
        /// w肵\t@CgpāA<see cref="TERASOLUNA.Fw.Common.Configuration.ExceptionTransitionConfigurationSection" />擾܂B
        /// </summary>
        /// <param name="configFileName">\t@C̃t@CB</param>
        /// <returns>Ɏw肵\t@C擾<see cref="TERASOLUNA.Fw.Common.Configuration.ExceptionTransitionConfigurationSection" /></returns>
        public static ExceptionTransitionConfigurationSection GetExceptionTransitionConfigurationSectionFromCustomFile(string configFileName)
        {
            return (ExceptionTransitionConfigurationSection)GetSectionFromCustomFile("exceptionTransitionConfiguration", configFileName);
        }

        /// <summary>
        /// w肵\t@CgpāA<see cref="TERASOLUNA.Fw.Web.Configuration.ExceptionCode.ExceptionCodeConfigurationSection" />擾܂B
        /// </summary>
        /// <param name="configFileName">\t@C̃t@CB</param>
        /// <returns>Ɏw肵\t@C擾<see cref="TERASOLUNA.Fw.Web.Configuration.ExceptionCode.ExceptionCodeConfigurationSection" /></returns>
        public static ExceptionCodeConfigurationSection GetExceptionCodeConfigurationSectionFromCustomFile(string configFileName)
        {
            return (ExceptionCodeConfigurationSection)GetSectionFromCustomFile("exceptionCodeConfiguration", configFileName);
        }

        /// <summary>
        /// w肵\t@CgpāA<see cref="TERASOLUNA.Fw.Web.Configuration.RequestController.RequestControllerConfigurationSection" />擾܂B
        /// </summary>
        /// <param name="configFileName">\t@C̃t@CB</param>
        /// <returns>Ɏw肵\t@C擾<see cref="TERASOLUNA.Fw.Web.Configuration.RequestController.RequestControllerConfigurationSection" /></returns>
        public static RequestControllerConfigurationSection GetRequestControllerConfigurationSectionFromCustomFile(string configFileName)
        {
            return (RequestControllerConfigurationSection)GetSectionFromCustomFile("requestControllerConfiguration", configFileName);
        }
    }
}
