// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionCode
{
    /// <summary>
    /// exceptionCode vf̃RNVi[\vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ExceptionCodeCollection"/> ́AOR[hݒt@C exceptionCode vf̃RNV\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElementCollection"/> QƂĂB
    /// </remarks>
    public class ExceptionCodeCollection : ConfigurationElementCollection
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ExceptionCodeCollection));

        /// <summary>
        /// <see cref="ExceptionCodeCollection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public ExceptionCodeCollection()
        {
        }

        /// <summary>
        /// <see cref="ExceptionCodeCollection"/> ̌^擾܂B 
        /// </summary>
        /// <remarks>
        /// ̃RNV <see cref="ConfigurationElementCollectionType"/>  <seealso cref="ConfigurationElementCollectionType.BasicMap"/> łB
        /// </remarks>
        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.BasicMap;
            }
        }

        /// <summary>
        /// V exceptionCode vf쐬܂B
        /// </summary>
        /// <returns><see cref="ExceptionCodeElement"/> NX̃CX^XB</returns>
        /// <remarks>
        /// V <see cref="ExceptionCodeElement"/> IuWFNg쐬܂B
        /// </remarks>
        protected override ConfigurationElement CreateNewElement()
        {
            return new ExceptionCodeElement();
        }

        /// <summary>
        /// w肵CfbNXʒuɂ exceptionCode vf擾܂B
        /// </summary>
        /// <param name="index">擾 <see cref="ExceptionCodeElement"/> ̃CfbNXʒuB</param>
        /// <value>w肵CfbNXʒuɂ <see cref="ExceptionCodeElement"/> B</value>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(int)"/> \bhgpāA<see cref="ExceptionCodeCollection"/>  <see cref="ExceptionCodeElement"/> IuWFNg擾܂B
        /// </remarks>
        public ExceptionCodeElement this[int index]
        {
            get
            {
                return (ExceptionCodeElement)BaseGet(index);
            }
        }

        /// <summary>
        /// w肵L[ exceptionCode vf擾܂B
        /// </summary>
        /// <param name="exceptionType">擾 exceptionCode vf̃L[BONX\B</param>
        /// <returns>w肵L[ <see cref="ExceptionCodeElement"/> B</returns>
        /// <remarks>
        /// <seealso cref="ConfigurationElementCollection.BaseGet(object)"/> \bhgpāA<see cref="ExceptionCodeCollection"/>  <see cref="ExceptionCodeElement"/> IuWFNg擾܂B
        /// w肵L[ <see cref="ExceptionCodeElement"/> IuWFNgRNVɑ݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        public virtual new ExceptionCodeElement this[string exceptionType]
        {
            get
            {
                return (ExceptionCodeElement)BaseGet(exceptionType);
            }
        }

        /// <summary>
        /// <see cref="ExceptionCodeCollection"/> ̗vf擾܂B
        /// </summary>
        /// <value>
        /// <see cref="ExceptionCodeCollection"/> ̗vfB
        /// </value>
        public virtual new int Count
        {
            get
            {
                return base.Count;
            }
        }

        /// <summary>
        /// OR[hݒt@Ĉ̗vf̃RNVʂ邽߂Ɏgp閼O擾܂B
        /// </summary>
        /// <value>
        /// RNVʂ邽߂Ɏgp閼OB
        /// </value>
        /// <remarks>
        /// vf "exceptionCode" łB
        /// </remarks>
        protected override string ElementName
        {
            get
            {
                return "exceptionCode";
            }
        }

        /// <summary>
        /// exceptionCode vf̗vfL[擾܂B
        /// </summary>
        /// <param name="element">L[Ԃ <see cref="ExceptionCodeElement"/> B</param>
        /// <returns>w肵 <see cref="ExceptionCodeElement"/> ̃L[Ƃċ@\ <see cref="Object"/> B</returns>
        /// <exception cref="System.ArgumentNullException">
        /// <paramref name="element"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.ArgumentException">
        /// <paramref name="element"/>  <see cref="ExceptionCodeElement"/> ł͂܂B
        /// </exception>
        protected override Object GetElementKey(ConfigurationElement element)
        {
            if (element == null)
            {
                ArgumentNullException exception = new ArgumentNullException("element");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Web.Properties.Resources.E_NULL_ARGUMENT, "element"), exception);
                }
                throw exception;
            }
            ExceptionCodeElement exTransElement = element as ExceptionCodeElement;
            if (exTransElement == null)
            {
                string message = string.Format(Web.Properties.Resources.E_INVALID_TYPE, "element");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return exTransElement.ExceptionType;
        }

        /// <summary>
        /// <see cref="ExceptionCodeCollection"/>  exceptionCode vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="ExceptionCodeElement"/> B</param>
        /// <remarks>
        /// <seealso cref="BaseAdd(ConfigurationElement)"/> \bhgpāARNVɐV <see cref="ExceptionCodeElement"/> ǉ܂B
        /// </remarks>
        public virtual void Add(ExceptionCodeElement element)
        {
            BaseAdd(element);
        }

        /// <summary>
        /// <see cref="ExceptionCodeCollection"/>  exceptionCode vfǉ܂B
        /// </summary>
        /// <param name="element">ǉ <see cref="ExceptionCodeElement"/> B</param>
        /// <remarks>
        /// w肵 <see cref="ExceptionCodeElement"/>  exceptionCode vfRNVɊɑ݂ꍇAO͔܂B
        /// </remarks>
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        /// <summary>
        /// <see cref="ExceptionCodeCollection"/> IuWFNgǂݎpǂl擾܂B 
        /// </summary>
        /// <returns>
        /// <see cref="ExceptionCodeCollection"/> IuWFNgǂݎp̏ꍇ true BȊȌꍇ false B
        /// </returns>
        /// <remarks>
        /// <see cref="ExceptionCodeCollection"/> IuWFNg͓ǂݎpł͂܂B
        /// </remarks>
        public override bool IsReadOnly()
        {
            return false;
        }
    }
}
