﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.Validators.RegexValidatorEx のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.Validators.RegexValidatorEx 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class RegexValidatorExTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///DefaultNegatedMessageTemplate のテスト
        ///</summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest()
        {
            //準備
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.Compiled;

            string messageTemplate = null;
            bool negated = true;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("REGEX_VALIDATOR_MESSAGETEMPLATE", placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            string actualDefaultMessageTemplate = accessor.DefaultNegatedMessageTemplate;

            //確認
            Assert.AreEqual(val, actualDefaultMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));      

        }

        /// <summary>
        ///DefaultNonNegatedMessageTemplate のテスト
        ///</summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest()
        {
            //準備
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.Compiled;
            string messageTemplate = null;
            bool negated = false;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("REGEX_VALIDATOR_MESSAGETEMPLATE", placeHolder);

            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            string actualDefaultMessageTemplate = accessor.DefaultNonNegatedMessageTemplate;

            //確認
            Assert.AreEqual(val, actualDefaultMessageTemplate, "プロパティの値が不正です");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullでNegatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest01()
        {
            //準備
            string objectToValidate = null;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = false;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);            

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字でNegatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest02()
        {
            //準備
            string objectToValidate = string.Empty;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = false;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定した文字が含まれて、Negatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest03()
        {
            //準備
            string objectToValidate = "TERASOLUNA";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = false;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定した文字が含まれてNegatedがfalseの場合、
        /// 検証結果がIsValid = falseであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest04()
        {
            //準備
            string objectToValidate = "terasoluna";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = false;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", currentTarget, "{3}", "{4}", "{5}" };
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("REGEX_VALIDATOR_MESSAGETEMPLATE", placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullが含まれてNegatedがtrueの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest05()
        {

            //準備
            string objectToValidate = null;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = true;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字が含まれてNagatedがtrueの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest06()
        {
            //準備
            string objectToValidate = string.Empty;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = true;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullが含まれてNegatedがtrue場合、
        /// 検証結果がIsValid = falseであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest07()
        {
            //準備
            string objectToValidate = "TERASOLUNA";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = true;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            ValidationResultList resultList = new ValidationResultList(results);

            //検証
            Assert.IsFalse(results.IsValid);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { "{0}", "{1}", currentTarget, "{3}", "{4}", "{5}" };
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("REGEX_VALIDATOR_MESSAGETEMPLATE", placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定した文字が含まれてNegatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest08()
        {
            //準備
            string objectToValidate = "terasoluna";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = true;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //検証
            Assert.IsTrue(results.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが正規表現とマッチする場合であり、ValidationResultsがnullの場合、
        /// ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest09()
        {

            //準備
            string objectToValidate = "TERASOLUNA";
            object currentTarget = null;
            string key = null;
            ValidationResults results = null;
            string pattern = "TERASOLUNA";
            string patternResourceName = null;
            Type patternResourceType = null;
            RegexOptions options = RegexOptions.None;
            string messageTemplate = null;
            bool negated = false;

            RegexValidatorEx target =
                new RegexValidatorEx(pattern, patternResourceName, patternResourceType, options, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_RegexValidatorExAccessor(target);

            try
            {
                //実施
                accessor.DoValidate(objectToValidate, currentTarget, key, results);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TargetInvocationException e)
            {
                // 確認
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(RegexValidatorEx), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(RegexValidatorEx), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "validationResults"));
        }
    }
}
