﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;

namespace TERASOLUNA.Fw.Common.Logging.TraceSourceLog
{
    /// <summary>
    /// <see cref="ILog"/> を継承したインターフェイスです。
    /// </summary>
    public interface ITraceSourceLog : ILog
    {
        /// <summary>
        /// Trace ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Trace(object message, int eventId);

        /// <summary>
        /// Trace レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Trace(object message, Exception ex, int eventId);

        /// <summary>
        /// Debug ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Debug(object message, int eventId);

        /// <summary>
        /// Debug レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Debug(object message, Exception ex, int eventId);

        /// <summary>
        /// Info ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Info(object message, int eventId);

        /// <summary>
        /// Info レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Info(object message, Exception ex, int eventId);

        /// <summary>
        /// Warn ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Warn(object message, int eventId);

        /// <summary>
        /// Warn レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Warn(object message, Exception ex, int eventId);

        /// <summary>
        /// Error ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Error(object message, int eventId);

        /// <summary>
        /// Error レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Error(object message, Exception ex, int eventId);

        /// <summary>
        /// Fatal ログレベルでメッセージをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Fatal(object message, int eventId);

        /// <summary>
        /// Fatal レベルでエラーをログ出力します。
        /// </summary>
        /// <param name="message">ログ出力するメッセージ。</param>
        /// <param name="ex">ログ出力の原因となった例外。</param>
        /// <param name="eventId">イベントの数値識別子。</param>
        void Fatal(object message, Exception ex, int eventId);
    }
}
