﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Common.Configuration
{
    /// <summary>
    /// アプリケーション構成ファイルの file 要素を表します。
    /// </summary>
    /// <remarks>
    /// <see cref="FileElement"/> は、アプリケーション構成ファイル内の file 要素を表します。 
    /// 詳細については <see cref="ConfigurationElement"/> を参照してください。
    /// </remarks>
    public class FileElement : ConfigurationElement
    {
        /// <summary>
        /// path 属性の属性名です。
        /// </summary>
        /// <remarks>
        /// この定数の値は、 "path" です。
        /// </remarks>
        private const string PATH_ATTRIBUTE_NAME = "path";

        /// <summary>
        /// <see cref="FileElement"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>デフォルトコンストラクタです。</remarks>
        public FileElement()
        {
        }

        /// <summary>
        /// path 属性の値を取得します。
        /// </summary>
        /// <value>
        /// path 属性の値。
        /// </value>
        [ConfigurationProperty(PATH_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string Path
        {
            get
            {
                return (string)this[PATH_ATTRIBUTE_NAME];
            }
        }
    }
}
