// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Xml;

namespace TERASOLUNA.Fw.Common.Configuration.BLogic
{
    /// <summary>
    /// AvP[V\t@C blogicConfiguration ZNV\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ConfigurationSection"/> NXgAblogicConfiguration JX^\nhłB
    /// ڍׂɂẮA<see cref="ConfigurationSection"/> QƂĂB
    /// </remarks>
    public class BLogicConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// blogicConfiguraiton ̗vfłB
        /// </summary>
        private const string SECTION_NAME = "blogicConfiguration";

        /// <summary>
        /// <see cref="FilesCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "files" łB
        /// </remarks>
        private const string FILES_ELEMENT_NAME = "files";

        /// <summary>
        /// <see cref="BLogicCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "blogicConfiguration" łB
        /// </remarks>
        private const string BLOGIC_CONFIGURATION_ELEMENT_NAME = "blogicConfiguration";

        /// <summary>
        /// blogic vf name łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "name" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_NAME = "name";

        /// <summary>
        ///  blogic vf type łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "type" łB
        /// </remarks>
        private const string TYPE_ATTRIBUTE_NAME = "type";

        /// <summary>
        /// rWlXWbNݒt@CXMLOԂłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "http://www.terasoluna.jp/schema/BLogicSchema.xsd" łB
        /// </remarks>
        private const string XML_NAMESPACE = "http://www.terasoluna.jp/schema/BLogicSchema.xsd";

        /// <summary>
        /// rWlXWbNݒt@CXMLOԃvtBbNXłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "bl" łB
        /// </remarks>
        private const string XML_NAMESPACE_PREFIX = "bl";

        /// <summary>
        /// rWlXWbNݒt@C}[WŊƂvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "bl:blogicConfiguration" łB
        /// </remarks>
        private const string SECTION_XPATH = XML_NAMESPACE_PREFIX + ":blogicConfiguration";

        /// <summary>
        /// rWlXWbNݒt@C}[WŃ}[Wvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "bl:blogicConfiguration/bl:blogic" łB
        /// </remarks>
        private const string ELEMENT_XPATH = SECTION_XPATH + "/" + XML_NAMESPACE_PREFIX + ":blogic";

        /// <summary>
        /// XML XL[}t@C̊SłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒ĺA "TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicSchema.xsd" łB
        /// </remarks>
        private const string XML_SCHEMA_FILE_NAME = "TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicSchema.xsd";

        /// <summary>
        /// <see cref="BLogicConfigurationSection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB</remarks>
        public BLogicConfigurationSection()
        {
        }

        /// <summary>
        /// files vf擾܂B
        /// </summary>
        /// <remarks>
        /// blogicConfiguration ZNV <see cref="FilesCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(FILES_ELEMENT_NAME, IsDefaultCollection = false, IsRequired = true)]
        public FilesCollection Files
        {
            get
            {
                FilesCollection filesCollection = (FilesCollection)base[FILES_ELEMENT_NAME];
                return filesCollection;
            }
        }

        /// <summary>
        /// blogicConfiguration vf擾܂B
        /// </summary>
        /// <remarks>
        /// blogicConfiguration ZNV <see cref="BLogicCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(BLOGIC_CONFIGURATION_ELEMENT_NAME, IsDefaultCollection = false)]
        public BLogicCollection BLogicCollection
        {
            get
            {
                BLogicCollection blogicCollection = (BLogicCollection)base[BLOGIC_CONFIGURATION_ELEMENT_NAME];
                return blogicCollection;
            }
        }

        /// <summary>
        /// files vf̐ݒe blogic vf𐶐 blogicConfiguration vfɒǉ܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="MergeConfiguration"/> NX̃CX^X𐶐ArWlXWbNݒt@C̐ݒ}[W܂B
        /// </para>
        /// <para>
        /// }[Wݒt@C̓e <see cref="BLogicElement"/> NX̃CX^X𐶐A <see cref="BLogicCollection"/> ɒǉ܂B
        /// </para>
        /// </remarks>
        /// <exception cref="ArgumentException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// rWlXWbNݒt@C}[WŊƂvf XPATH słB
        /// </item>
        /// <item>
        /// rWlXWbNݒt@C}[WŃ}[Wvf XPATH słB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C rWlXWbNݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// rWlXWbNݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// rWlXWbNݒt@C}[WŊƂvf XPATH  rWlXWbNݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public void CreateBLogicElements()
        {
            // Oݒt@C̐ݒ}[W
            MergeConfiguration mgConfig = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            mgConfig.LoadConfig(SECTION_NAME, Files);
            XmlDocument xmlDoc = mgConfig.MergeXmlDocument(SECTION_XPATH, ELEMENT_XPATH);

            // Oݒt@C̐ݒblogicConfigurationvfɒǉ
            AddBlogicElements(xmlDoc);
        }

        /// <summary>
        /// rWlXWbNݒt@C̓e blogic vf𐶐A blogicConfiguration vfɒǉ܂B
        /// </summary>
        /// <param name="xmlDoc">rWlXWbNݒt@C̓eێ <see cref="XmlDocument" /> B
        /// </param>
        private void AddBlogicElements(XmlDocument xmlDoc)
        {
            XmlNodeList list = xmlDoc.DocumentElement.ChildNodes;

            foreach (XmlNode node in list)
            {
                if (node is XmlElement)
                {
                    //BlogicDbInfoElement쐬BLogicDbInfoRNV쐬
                    BLogicDbInfoCollection@dbInfoColl = new BLogicDbInfoCollection();
                    AddDbInfoElement(dbInfoColl, node);

                    //BlogicElement쐬iLō쐬BLogicDbInfoRNV܂ށjāABLogicCollectionɒǉ
                    string name = node.Attributes[NAME_ATTRIBUTE_NAME].InnerText;
                    string type = node.Attributes[TYPE_ATTRIBUTE_NAME].InnerText;
                    BLogicElement element = new BLogicElement(name, type, dbInfoColl);
                    BLogicCollection.Add(element);
                }
            }
        }

        /// <summary>
        /// DbInfo vf쐬A<paramref cref="BLogicDbInfoCollection"/> ɒǉ܂B
        /// </summary>
        /// <param name="DbInfoCollection"></param>
        /// <param name="xmlCurrentBlogic">blogicvf̏ێ<see cref="XmlNode" /> B</param>
        private static void AddDbInfoElement(BLogicDbInfoCollection DbInfoCollection, XmlNode xmlCurrentBlogic)
        {
            foreach (XmlNode xmlDbInfo in xmlCurrentBlogic)
            {
                BLogicDbInfoElement dbInfoElement = CreateDbInfoElement(xmlDbInfo);
                DbInfoCollection.Add(dbInfoElement);
            }
        }

        /// <summary>
        /// V DbInfo vf쐬܂B
        /// </summary>
        /// <param name="xmlNode">DbInfovf̏ێ<see cref="XmlDocument" /> B</param>
        private static BLogicDbInfoElement CreateDbInfoElement(XmlNode xmlNode)
        {
            string name = xmlNode.Attributes[NAME_ATTRIBUTE_NAME].InnerText;
            BLogicDbInfoElement ret = new BLogicDbInfoElement(name);
            return ret;
        }
    }
}
