// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Text;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Common.Configuration.BLogic
{
    /// <summary>
    /// rWlXWbNݒt@C <see cref="BLogicConfiguration"/> ݒ擾܂B
    /// </summary>
    public abstract class BLogicConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BLogicConfiguration));

        /// <summary>
        /// BLogic ̃^Cv擾܂B
        /// </summary>
        /// <param name="name">擾 <see cref="Common.BLogic.IBLogic"/> ̎ʎqB</param>
        /// <returns>݂ꍇ́A<paramref name="name"/> ̒lɑΉ <see cref="Common.BLogic.IBLogic"/> ̃^CvBȊȌꍇ null QƂłB</returns>
        /// <remarks>
        /// rWlXWbNݒt@CA<paramref name="name"/> ̒lɑΉ type ̒l擾܂B
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="name"/> ̕łB
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// <item>
        /// <see cref="BLogicConfigurationSection"/> 擾ł܂B
        /// </item>
        /// </exception>
        public static string GetBLogicTypeName(string name)
        {
            if (name == null)
            {
                ArgumentNullException exception = new ArgumentNullException("name");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                }
                throw exception;
            }
            if (name.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "name");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            BLogicConfigurationSection  blogicConfigSection = TerasolunaConfiguration.BLogicConfigSection;
            BLogicElement element;
            if (blogicConfigSection == null)
            {
                return null;
            }
            else
            {
                element = blogicConfigSection.BLogicCollection[name];
            }
            
            // nameɑΉݒ肪ꍇnullԋp
            if (element == null)
            {
                if (_log.IsTraceEnabled)
                {
                    _log.Trace(string.Format(
                        Properties.Resources.T_BLOGIC_CONFIGURATION_NOT_LOAD_PARAMETER, name));
                }

                return null;
            }

            if (_log.IsTraceEnabled)
            {
                _log.Trace(string.Format(
                    Properties.Resources.T_BLOGIC_CONFIGURATION_LOAD_PARAMETER, name, element.Type));
            }

            return element.Type;
        }

        /// <summary>
        /// <see cref="Common.BLogic.IBLogic"/> p DB ڑ̎ʎq擾܂B
        /// </summary>
        /// <param name="name">擾 <see cref="Common.BLogic.IBLogic"/> ̎ʎqB</param>
        /// <returns>݂ꍇ́A<paramref name="name"/> ̒lɑΉ <see cref="Common.BLogic.IBLogic"/>  DB ڑ̃XgB
        /// ȊȌꍇ͋ <see cref="List{String}"/> ԋp܂B</returns>
        /// <remarks>
        /// rWlXWbNݒt@CA<paramref name="name"/> ̒lɑΉ dbInfo m[h̒l擾܂B
        /// </remarks>
        /// <exception cref="System.ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.ArgumentException">
        /// <paramref name="name"/> ̕łB
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// <item>
        /// <see cref="BLogicConfigurationSection"/> 擾ł܂B
        /// </item>
        /// </exception>
        public static List<string> GetDbNames(string name)
        {
            if (name == null)
            {
                ArgumentNullException exception = new ArgumentNullException("name");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                }
                throw exception;
            }
            if (name.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "name");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            List<string> dbNames = new List<string>();

            BLogicConfigurationSection blogicConfigSection = TerasolunaConfiguration.BLogicConfigSection;
            BLogicDbInfoCollection dbInfos;
            if (blogicConfigSection != null)
            {
                if (blogicConfigSection.BLogicCollection[name] != null)
                {
                    dbInfos = blogicConfigSection.BLogicCollection[name].DbInfos;
                    foreach (BLogicDbInfoElement dbInfo in dbInfos)
                    {
                        dbNames.Add(dbInfo.Name);
                    }
                }
            }

            if (_log.IsTraceEnabled)
            {
                if (dbNames.Count == 0)
                {
                    _log.Trace(string.Format(Properties.Resources.T_NO_DBINFO_COLLECTION, name));
                }
                else
                {
                    StringBuilder builder = new StringBuilder(
                        string.Format(Properties.Resources.T_DBINFO_COLLECTION, name));
                    foreach (string dbName in dbNames)
                    {
                        builder.AppendLine(dbName);
                    }
                    _log.Trace(builder.ToString().Trim());
                }
            }

            return dbNames;
        }
    }
}
