// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client.Conversion;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.CommonUT.Conversion.ConverterFactoryTestData
{
    /// <summary>
    /// ConverterFactory 単体試験用のスタブクラスです。
    /// </summary>
    /// <remarks>
    /// デフォルトコンストラクタが定義されています。
    /// </remarks>
    public class ConverterFactory_Stub02 : ConverterFactory
    {
        public Type _converterType = null;

        public ConverterFactory_Stub02()
        { 
        }

        protected override IConverter CreateInstance()
        {
            IConverter converter = null;

            if (_converterType == null)
            {
                // 型がキャッシュされていなければ設定ファイルから型名を取得して生成
                converter =
                    ClassUtil.CreateInstanceFromAppSettings<IConverter>(CONVERTER_TYPENAME, typeof(ConverterFactory_IConverterImpl01));

                // 生成したインスタンスの型をキャッシュ
                _converterType = converter.GetType();
            }
            else
            {
                // 型がキャッシュされていれば、その型のインスタンスを生成
                converter =
                    ClassUtil.CreateInstanceByType<IConverter>(_converterType);
            }

            return converter;
        }
    }
}
