// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Conversion;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.ClientUT.Conversion
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Conversion.ConversionException のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Conversion.ConversionException 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ConversionExceptionTest
    {
        private TestContext testContextInstance;

        ///<summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        ///<summary>
        /// ConversionException () のテスト
        ///</summary>
        ///<remarks>
        /// デフォルトコンストラクタを実行した場合に、
        /// E_CONVERSION_EXCEPTIONがメッセージに設定されていることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備
            string expectedMessage = TERASOLUNA_Fw_Client_Properties_ResourcesAccessor.E_CONVERSION_EXCEPTION;

            // 実行
            ConversionException target = new ConversionException();
            string actualMessage = target.Message;

            // 検証
            Assert.AreEqual(expectedMessage, actualMessage);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionException), LogLevel.INFO));

        }

        ///<summary>
        /// ConversionException (string) のテスト
        ///</summary>
        ///<remarks>
        /// 引数に有効なメッセージを渡した場合
        /// 例外メッセージとしてメッセージが取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorStringTest01()
        {
            // 準備
            string expectedMessage = "errormessage";

            // 実行
            ConversionException target = new ConversionException(expectedMessage);
            string actualMessage = target.Message;

            // 検証
            Assert.AreEqual(expectedMessage, actualMessage);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionException), LogLevel.INFO));

        }

        ///<summary>
        /// ConversionException (string, Exception) のテスト
        ///</summary>
        ///<remarks>
        /// messageに有効な値、innerに有効な値を渡した場合
        /// Message、InnerExceptionともに正常に取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorStringExcxeptionTest01()
        {
            // 準備
            string expectedMessage = "errormessage";
            Exception expectedException = new Exception();

            // 実行
            ConversionException target = new ConversionException(expectedMessage, expectedException);
            string actualMessage = target.Message;
            Exception actualException = target.InnerException;

            // 検証
            Assert.AreEqual(expectedMessage, actualMessage);
            Assert.AreSame(expectedException, actualException);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ConversionException), LogLevel.INFO));
        }
    }
}
