// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;

namespace TERASOLUNA.Fw.Client
{
    /// <summary>
    /// <see cref="EventController.ValidationFailed"/> Cxg̃f[^񋟂܂B
    /// </summary>
    /// <remarks>
    /// Cxg@\񋟂͒l؃G[Cxg (<see cref="EventController.ValidationFailed"/>)
    /// ̃Cxgnh֓np^łB
    /// </remarks>
    public class ValidationFailedEventArgs : EventArgs
    {

        /// <summary>
        /// <see cref="Coordinator"/> ł̓͒l؃G[ʁB
        /// </summary>
        private ExecutionResult _executionResult = null;

        /// <summary>
        /// <see cref="Coordinator"/> ł̓͒l؃G[ʂ擾܂B
        /// </summary>
        /// <value>
        /// <see cref="Coordinator"/> ł̓͒l؃G[ʁB
        /// </value>
        public ExecutionResult ExecutionResult
        {
            get
            {
                return _executionResult;
            }
        }

        /// <summary>
        /// <see cref="ValidationFailedEventArgs"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="executionResult">
        /// <see cref="Coordinator"/> ł̓͒l؃G[ʁB
        /// </param>
        public ValidationFailedEventArgs(ExecutionResult executionResult)
        {
            _executionResult = executionResult;
        }
    }
}
