// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Data;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.BLogic
{
    /// <summary>
    /// XMLf[^̑MsrWlXWbNNXłB
    /// </summary>
    /// <remarks>
    /// <see cref="DataSetXmlCommunicator{TResult}"/> gpăT[oƒʐMs܂B
    /// </remarks>
    /// <typeparam name="TResult">
    /// MXMLf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
    /// </typeparam>
    public class DataSetXmlCommunicateBLogic<TResult> : CommunicateBLogicBase<DataSet> 
        where TResult : DataSet, new()
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(DataSetXmlCommunicateBLogic<TResult>));

        /// <summary>
        /// <see cref="DataSetXmlCommunicateBLogic{TResult}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public DataSetXmlCommunicateBLogic()
        {
        }

        /// <summary>
        /// XMLf[^̑Ms <see cref="ICommunicator{DataSet}"/> 𐶐܂B
        /// </summary>
        /// <remarks>
        /// ł <see cref="DataSetXmlCommunicator{TResult}"/> 𐶐܂B
        /// </remarks>
        /// <returns>
        /// XMLf[^̑Ms <see cref="ICommunicator{DataSet}"/>B
        /// </returns>
        protected override ICommunicator<DataSet> CreateCommunicator()
        {
            return new DataSetXmlCommunicator<TResult>();
        }

        /// <summary>
        /// XMLf[^̑Ms܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <see cref="ICommunicator{DataSet}"/>  <see cref="ICommunicator{DataSet}.Communicate"/> s܂B
        /// <see cref="ICommunicator{DataSet}.Communicate"/> ł
        /// ̓f[^ <paramref name="paramData"/> XMLɕϊăT[o֑MA
        /// Mf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
        /// </para>
        /// <para>
        /// ʐMNXƂāAł <see cref="DataSetXmlCommunicator{TResult}"/> 𗘗p܂B
        /// </para>
        /// </remarks>
        /// <param name="communicateBlogicParam">
        /// rWlXWbNɓ͂ꂽp[^ <see cref="BLogicParam"/>B
        /// </param>
        /// <param name="requestHeaders">
        /// NGXg̃wb_\閼Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B
        /// </param>
        /// <returns>
        /// ʐMʂi[ <see cref="CommunicationResult"/>B
        /// </returns>
        /// <exception cref="ArgumentException">
        /// ʐMŕKvȃf[^słB
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oAvP[Vőz肵ȂO܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// f[^̑MɃG[܂B
        /// </exception>
        protected override CommunicationResult Communicate(BLogicParam communicateBlogicParam,
                                                           IDictionary<string, string> requestHeaders)
        {
            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_BEGIN_COMMUNICATOR_FUNCTION, Communicator.GetType().FullName));
            }

            // M
            CommunicationResult communicationResult = 
                Communicator.Communicate(communicateBlogicParam.ParamData, requestHeaders);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_END_COMMUNICATOR_FUNCTION, Communicator.GetType().FullName));
            }

            return communicationResult;
        }

    }

}
