/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.FastHashMap;

import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.openapi.JobContext;


/**
 * Rg[uCNPʂɁA`N쐬 <code>CollectedDataHandler
 * </code>̎NXB
 * 
 * <p>1̃Wuɑ΂āÃRg[uCN`邱ƂłB
 * ܂Rg[uCN̂̂P́AgUNVEƈv悤
 * `KvÂ悤ȃRg[uCN
 * <em>"gUNViRg[uCN"</em>ƌĂԁB</p>
 * 
 * <p><code>Collector</code> Ahandle()\bhŎWf[^̏˗
 * ꂽۂɁA<code>transactionalBreakKey</p> ɐݒ肳ĂgUNVi
 * Rg[uCNL[̒`ɊÂāA`N𕪊B</p>
 * 
 * <p><code>controlBreakHandlerMap</code> ɐݒ肳ĂRg[uCN
 * `ɊÂāAhandle()\bhɓnꂽrWlXWbN̓f[^ŃRg
 * [uCNĂ邩ǂ`FbNBRg[uCN
 * Ăꍇɂ́AuCNL[Ƃꂼ̃uCNL[̒lݒ肷B</p>
 * 
 * <p>쐬`ŃARXgN^œnꂽ <code>WorkQueue</code> ɐݒ
 * B</p>
 * 
 */
public class ControlBreakChunker implements CollectedDataHandler {

    /**
     * 쐬`NL[CO <code>WorkQueue</code> CX^XB
     */
    private WorkQueue queue;
    
    /**
     * Rg[uCN̒`B
     */
    private final ControlBreakDef controlBreakDef;

    /**
     * ̃`NB
     */
    private ControlBreakChunk currentChunk;
    
    /**
     * WuReNXgB
     */
    private JobContext jobContext;
    
    /**
     * `NTCYB
     */
    private int chunkSize = 20;
    
    /**
     * `NRg[uCN̐ݒLB
     */
    private boolean chunkControlFlg = false;

    
    /**
     * ̏f[^
     */
    private ControlBreakRowObject newRow = null;

    
    /**
     * RXgN^B
     * 
     * @param queue 쐬`NL[CO <code>WorkQueue</code> 
     * CX^X
     * @param jobContext WuReNXg
     * @param controlBreakDef Rg[uCN̒`
     * @param chunkSize `NTCY
     */
    public ControlBreakChunker(WorkQueue queue, JobContext jobContext,
            ControlBreakDef controlBreakDef, int chunkSize) {
        this.queue = queue;
        this.jobContext = jobContext;
        this.controlBreakDef = controlBreakDef;
        this.chunkSize = chunkSize;
        if (controlBreakDef.getChunkControlBreakDefItem() == null
                || controlBreakDef.getChunkControlBreakDefItem().getBreakKey()
                        .size() == 0) {
            this.chunkControlFlg = true;
        }
        currentChunk = new ControlBreakChunk(jobContext, controlBreakDef,
                chunkSize);
    }

    /**
     * RN^ŎWf[^B
     * 
     * <p>
     * Rg[uCNĂ邩ǂ𔻒肵AgUNViR
     * g[uCNĂꍇɂ́AOf[^܂ł`NƂăL
     * [COB
     * </p>
     * 
     * @param row
     *            RN^ŎWf[^
     * @param collected
     *            <code>row</code> AWf[^ŉԖڂ̃f[^ł邩
     *            CfbNX
     */
    public void handle(Object row, int collected) {
        newRow = currentChunk.setNext(row);

        // Rg[uCN̕ێ
        if (currentChunk.isChunkControlBreak()
                || (chunkControlFlg && currentChunk.size() >= chunkSize)) {
            // `N̏I[}[Nݒ ĩf[^Rg[uCN
            // 󂯎j
            ControlBreakRowObject chunkRow = new ControlBreakRowObject(
                    ControlBreakChunk.CHUNK_BREAK_MARK, newRow
                            .getControlBreakKeyList(), newRow
                            .getControlBreakMap());
            currentChunk.add(chunkRow);
            // `Nf[^̏
            queue.put(currentChunk);
            FastHashMap methodMap = currentChunk.getMethodMap();
            // ݂̃Rg[uCNL[̃`NɈp
            currentChunk = new ControlBreakChunk(jobContext, controlBreakDef,
                    chunkSize, currentChunk.getNextData(), currentChunk
                            .getChunkNextData());
            currentChunk.setMethodMap(methodMap);
            // Rg[uCNNAi`N̏I[}[NɈڏ
            // ߁j
            newRow = new ControlBreakRowObject(newRow.getRowObject(),
                    new ArrayList<List<String>>(), null);
        }

        currentChunk.add(newRow);
    }

    /**
     * IsB
     * 
     * <p>̃`NL[COA<code>WorkQueue</code> CX^X
     * ̃N[YsB</p>
     */
    public void close() {
        ControlBreakRowObject row = null;
        if (newRow != null) {
            row = currentChunk.setLastData(newRow.getRowObject());
        } else {
            row = new ControlBreakRowObject(ControlBreakChunk.END_MARK, null,
                    null);
        }
        currentChunk.add(row);
        currentChunk.setEndChunk(true);
        queue.put(currentChunk);
        currentChunk = null;
        queue.close();
    }
}
