/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.dao.FileException;

/**
 * Œ蒷t@Cp̃t@CANZX(f[^擾)NXB
 * 
 * <p>
 * Œ蒷t@Cf[^ǂݍ݁A
 * 1s̃f[^t@CsIuWFNgɊi[B
 * </p>
 * 
 * <b>pt@CsIuWFNg̃Ame[V</b><br>
 * @D@{@link FileFormat}̐ݒ荀<br>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b>_ږ</b> </td>
 *    <td> <b>ږ</b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>s؂蕶</code> </td>
 *    <td> <code>lineFeedChar</code> </td>
 *    <td> <code>VXe̍s؂蕶</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *   <tr>
 *    <td> <code>t@CGR[fBO</code> </td>
 *    <td> <code>fileEncodeing</code> </td>
 *    <td> <code>VXẽt@CGR[fBO</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *   <tr>
 *    <td> <code>wb_s</code> </td>
 *    <td> <code>headerLineCount</code> </td>
 *    <td> <code>0</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *   <tr>
 *    <td> <code>gCs</code> </td>
 *    <td> <code>trailerLineCount</code> </td>
 *    <td> <code>0</code> </td>
 *    <td> <code>IvV</code> </td>
 *   <tr>
 *  </table>
 * </div>
 * <br>
 * AD@{@link InputFileColumn}A@{@link jp.terasoluna.fw.file.annotation.OutputFileColumn}̐ݒ荀<br>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b>_ږ</b> </td>
 *    <td> <b>ږ</b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>JCfbNX</code> </td>
 *    <td> <code>columnIndex</code> </td>
 *    <td> - </td>
 *    <td> <code>K{</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>tH[}bg</code> </td>
 *    <td> <code>columnFormat</code> </td>
 *    <td> <code>""</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>oCg</code> </td>
 *    <td> <code>bytes</code> </td>
 *    <td> <code>-1</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>pfBO</code> </td>
 *    <td> <code>paddingType</code> </td>
 *    <td> <code>pfBOȂ</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>pfBO</code> </td>
 *    <td> <code>paddingChar</code> </td>
 *    <td> <code>' '</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>g</code> </td>
 *    <td> <code>trimType</code> </td>
 *    <td> <code>gȂ</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>g</code> </td>
 *    <td> <code>trimChar</code> </td>
 *    <td> <code>' '</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>ϊ</code> </td>
 *    <td> <code>stringConverter</code> </td>
 *    <td> <code>NullStringConverter.class</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *  </table>
 * </div>
 * <br>
 * <b>ӎ</b><br>
 * <ul>
 * @<li>؂蕶ݒ肷邱Ƃ͏oȂB(G[)</li>
 * @<li>͂ݕݒ肷邱Ƃ͏oȂB(G[)</li>
 * </ul>
 * 
 * 
 * @param <T>
 *            t@CsIuWFNgB
 */
public class FixedFileLineIterator<T> extends AbstractFileLineIterator<T> {

    /**
     * ؂蕶BŒ蒷t@Ću,(J})vŌŒB
     */
    private static final char DELIMITER = ',';

    /**
     * ͂ݕBŒ蒷t@Ću'\u0000'vŌŒB
     */
    private static final char ENCLOSE_CHAR = Character.MIN_VALUE;

    /**
     * RXgN^B
     * 
     * @param fileName
     *            t@C
     * @param clazz
     *            ʃNX
     * @param textSetterMap
     *            tH[}bgXg
     */
    public FixedFileLineIterator(String fileName, Class<T> clazz,
            Map<String, ColumnParser> textSetterMap) {

        super(fileName, clazz, textSetterMap);

        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);

        // ؂蕶lȊȌꍇAOX[B
        if (fileFormat.delimiter() != DELIMITER) {
            throw new FileException("Delimiter can not change.",
                    new IllegalStateException(), fileName);
        }

        // ͂ݕlȊȌꍇAOX[B
        if (fileFormat.encloseChar() != ENCLOSE_CHAR) {
            throw new FileException("EncloseChar can not change.",
                    new IllegalStateException(), fileName);
        }
    }

    /**
     * ǂݍ񂾌Œ蒷̃R[hAme[VbyteA
     * columnIndex]ĕB
     * 
     * <p>
     * ̏́A<br>
     * <ul>
     * <li>t@CsIuWFNg̃Ame[VŒ`columnIndex̏ɕёւ</li>
     * <li>t@CsIuWFNg̃Ame[VŒ`bytes̕𐶐</li>
     * <li>2oCgmFہAbyteszĊi[悤ƂƗOX[</li>
     * <li>columnIndex̔(r̔ԍȂꍇAĂꍇ)͏p邪A
     * columnIndexɏdꍇ́A̎_ŗOX[</li>
     * </ul>
     * <p>
     * 
     * @param fileLineString
     *            Œ蒷t@Ĉ1R[h̕
     * @return f[^Ps̕𕪉z
     */
    protected String[] separateColumns(String fileLineString) {

        // t@CsIuWFNgŒ`ĂJ̃oCg̍vi[B
        int columnBytesTotal = 0;

        if (fileLineString == null || "".equals(fileLineString)) {
            return new String[0];
        }

        Field[] fieldList = new Field[getFields().length];

        List<String> columnList = new ArrayList<String>();

        // t@CsIuWFNg̑,Ame[VŒ`columnIndex
        // ɕבւBdꍇ̓G[ƂB
        for (Field field : getFields()) {
            if (field != null) {
                InputFileColumn inputFileColumn = field
                        .getAnnotation(InputFileColumn.class);
                if (inputFileColumn != null) {
                    if (fieldList[inputFileColumn.columnIndex()] == null) {
                        fieldList[inputFileColumn.columnIndex()] = field;
                    } else {
                        throw new FileException("Column index is repeated.",
                                this.getFileName());
                    }
                }
            }
        }
        StringBuilder columnBuilder = new StringBuilder();
        int fileLineStringIndex = 0;
        for (Field field : fieldList) {
            int columnBytes = 0;
            // columnBuilder̃f[^NA
            columnBuilder.delete(0, columnBuilder.length());
            if (field != null) {
                InputFileColumn inputFileColumn = field
                        .getAnnotation(InputFileColumn.class);
                // J̃oCgAme[VŐݒ肵oCg
                // ȂԁA[v񂷁B
                while (columnBytes < inputFileColumn.bytes()) {

                    if (fileLineString.length() <= fileLineStringIndex) {
                        throw new FileException("Data size is different from"
                                + " a set point of a column.",
                                this.getFileName());
                    }

                    // 1s̕񂩂1o
                    String columnChar = fileLineString.substring(
                            fileLineStringIndex, fileLineStringIndex + 1);
                    try {
                        // ܂łɓǂݎĂJ̃oCgƁAǂݎ
                        // ̃oCgAme[VƂmFB
                        if ((columnChar.getBytes(getFileEncoding()).length
                                + columnBytes) <= inputFileColumn.bytes()) {
                            // ǂݎcolumnBuilder֒ǉB
                            columnBuilder.append(columnChar);
                            // ǂݎ̃oCgǉB
                            columnBytes = columnBytes
                                + columnChar.getBytes(getFileEncoding()).length;
                            // ǂݎ镶̃CfbNX1炷B
                            fileLineStringIndex++;
                        } else {
                            throw new FileException("Data size is different "
                                    + "from a set point of a column.",
                                    this.getFileName());
                        }
                    } catch (UnsupportedEncodingException e) {
                        throw new FileException(e, this.getFileName());
                    }
                }
                columnBytesTotal += inputFileColumn.bytes();
                columnList.add(columnBuilder.toString());
            }
        }
        // t@Cǂݎ1s̃oCgƁAt@CsIuWFNg
        // `oCg̍vrB
        try {
            if (columnBytesTotal
                    != fileLineString.getBytes(getFileEncoding()).length) {
                throw new FileException("Total Columns byte is different "
                        + "from Total FileLineObject's columns byte.",
                        new IllegalStateException(), this.getFileName());
            }
        } catch (UnsupportedEncodingException e) {
            throw new FileException(e, this.getFileName());
        }
        return columnList.toArray(new String[columnList.size()]);
    }

    /**
     * ؂蕶擾B<br>
     * Œ蒷t@Ću,(J})vŌŒB
     * 
     * @return s؂蕶
     */
    @Override
    public char getDelimiter() {

        return DELIMITER;
    }

    /**
     * ͂ݕ擾B<br>
     * Œ蒷t@Ću'\u0000'vŌŒB
     * 
     * @return ͂ݕ
     */
    @Override
    public char getEncloseChar() {

        return ENCLOSE_CHAR;
    }
}
