/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import jp.terasoluna.fw.batch.core.BLogicExecutor;
import jp.terasoluna.fw.batch.core.BatchUpdateException;
import jp.terasoluna.fw.batch.core.BatchUpdateProcessor;
import jp.terasoluna.fw.batch.core.BatchUpdateResultHandler;
import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobWorker
implements Workable<Chunk> {
    private static Log log = LogFactory.getLog(JobWorker.class);
    protected LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    protected JobExceptionHandler defaultJobExceptionHandler = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();
    protected BatchUpdateProcessor batchUpdateProcessor = null;
    protected BatchUpdateResultHandler batchUpdateResultHandler = null;
    private BLogicExecutor blogicExecutor = null;

    @Override
    public void work(Chunk chunk, JobStatus jobStatus) {
        this.writeStartLog(jobStatus);
        if (chunk.size() == 0) {
            throw new IllegalArgumentException("chunk size is 0");
        }
        try {
            ArrayList<LinkedHashMap<String, Object>> batchUpdateMapList = new ArrayList<LinkedHashMap<String, Object>>();
            for (Object blogicInputData : chunk) {
                if (jobStatus.isShutdownImmediate()) {
                    jobStatus.suspend();
                    return;
                }
                this.blogicExecutor.executeBLogic(blogicInputData, chunk.getJobContext(), jobStatus, batchUpdateMapList);
                if (jobStatus.isContinue()) continue;
                if (jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY) break;
                return;
            }
            this.processBatchUpdate(chunk.getJobContext(), jobStatus, batchUpdateMapList);
            this.writeEndLog(jobStatus);
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(chunk.getJobContext(), throwable, jobStatus);
        }
    }

    protected void processBatchUpdate(JobContext jobContext, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (batchUpdateMapList.size() == 0) {
            return;
        }
        try {
            this.batchUpdateProcessor.processBatchUpdate(batchUpdateMapList);
            this.batchUpdateResultHandler.handle(jobStatus, batchUpdateMapList);
        }
        catch (RuntimeException e) {
            BatchUpdateException wrappingException = new BatchUpdateException(e, batchUpdateMapList);
            JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
            try {
                handler.handlException(jobContext, wrappingException, jobStatus);
            }
            catch (RuntimeException handlerException) {
                log.error((Object)("[Exception in ExceptionHandler] Error JobID: " + jobStatus.getJobId()), (Throwable)handlerException);
                jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
            }
        }
    }

    public void setExceptionHandlerMap(LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    public void setBatchUpdateProcessor(BatchUpdateProcessor batchUpdateProcessor) {
        this.batchUpdateProcessor = batchUpdateProcessor;
    }

    public void setBlogicExecutor(BLogicExecutor blogicExecutor) {
        this.blogicExecutor = blogicExecutor;
    }

    public void setBatchUpdateResultHandler(BatchUpdateResultHandler batchUpdateResultHandler) {
        this.batchUpdateResultHandler = batchUpdateResultHandler;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    private void writeStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("JobWorker processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicExecutorName=");
            logStr.append(this.blogicExecutor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateProcessorName=");
            logStr.append(this.batchUpdateProcessor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateResultHandlerName=");
            logStr.append(this.batchUpdateResultHandler.getClass().getSimpleName());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    private void writeEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("JobWorker processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [BLogicExecutorName=");
            logStr.append(this.blogicExecutor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateProcessorName=");
            logStr.append(this.batchUpdateProcessor.getClass().getSimpleName());
            logStr.append("] [BatchUpdateResultHandlerName=");
            logStr.append(this.batchUpdateResultHandler.getClass().getSimpleName());
            logStr.append("] [BatchUpdateCount=");
            logStr.append(jobStatus.getBatchUpdateCount());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

