/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.validation;

import org.springframework.validation.Validator;

import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectedDataHandlerFactory;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * ̓`FbNp`J[𐶐t@NgNXB
 *
 */
public class ValidationExecutorFactory 
    implements CollectedDataHandlerFactory {

    /**
     * Ώۃf[^p`N쐬pNXB
     */
    private CollectedDataHandlerFactory collectedDataHandlerFactory = null;
    
    /**
         * of[^B
         */
    private Validator validator = null;
    
        /**
        * of[^ʃnhB
        */
    private ValidationResultHandler validationResultHandler = null;
    
    /**
     * ̓`FbNp`J[𐶐B
     *
     * @param workQueue `J[`NZbgL[
     * @param jobContext WuReNXg
     * @return `J[
     */
    public CollectedDataHandler getHandler(WorkQueue workQueue,
            JobContext jobContext) {
        CollectedDataHandler handler =
            collectedDataHandlerFactory.getHandler(workQueue, jobContext);
        return 
          new ValidationExecutor(handler , validator , validationResultHandler);
    }

    /**
     * of[^ʃnhݒ肷B
     * 
     * @param validationResultHandler of[^ʃnh
     */
    public void setValidationResultHandler(
            ValidationResultHandler validationResultHandler) {
        this.validationResultHandler = validationResultHandler;
    }

    /**
     * of[^ݒ肷B
     * 
     * @param validator of[^
     */
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    /**
     * Ώۃf[^p`N쐬pNXݒ肷B
     * 
     * @param collectedDataHandlerFactory Ώۃf[^p`N쐬pNX
     */
    public void setCollectedDataHandlerFactory(
            CollectedDataHandlerFactory collectedDataHandlerFactory) {
        this.collectedDataHandlerFactory = collectedDataHandlerFactory;
    }
}
