/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * t@CCollector̕WNXB
 * <p>
 *   t[[Ñt@CANZX@\pē̓t@C(CSV`AŒ蒷`
 *   Aϒ`)̏Ώۃf[^̎擾@\񋟁B
 * </p>
 * <p>
 *  <li>t@CQueryDAO</li> <li>̓t@C</li> <li>ʃNX(t@CsIuWF
 *  Ng)</li><li>FileLineExceptionA㑱ptO<p>𑮐lƂ
 *  ݒ肷KvB</li></p>
 * </p>
 * <br>
 *<strong>ݒ</strong>
 * <code><pre>
 *  &lt;!-- RN^[` --&gt;
 *   &lt;bean id="collector" parent="fileChunkCollector"&gt
 *       &lt;property name="fileQueryDao" ref="csvFileQueryDAO" /&gt
 *       &lt;property name="inputFileName" value="../INPUTFILE/SAMPLE/sampledata.csv" /&gt
 *       &lt;property name="resultClass"&gt
 *           &lt;bean class="jp.terasoluna.batch.sample.FileLine001" /&gt
 *       &lt;/property&gt
 *       &lt;property name="readNextLine" value="true" /&gt
 *   &lt;/bean&gt
 * </pre></code>
 * 
 */
public class StandardFileCollector extends AbstractCollector {
    
    /**
     * t@CANZXpDAOB
     */
    private FileQueryDAO fileQueryDao = null;

    /**
     * ʃNXB
     */
    private Object resultClass = null;

    /**
     * ̓t@CB
     */
    private String inputFileName = null;
    
    /**
     * FileLineExceptionX[A㑱p̃tOB
     */
    private boolean readNextLine = false;
    
    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(StandardFileCollector.class);

    /**
     * ̓t@Cf[^擾B
     *
     * @param jobContext WuReNXg
     * @param collectedDataHandler Wf[^nh
     * @param jobStatus WuXe[^X
     * @return RN^̏
     */
    @Override
    protected CollectorResult doCollect(JobContext jobContext,
            CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        
        // ύs̃JEg
        int collected = 0;
        
        // t@CsIuWFNgێCe[^擾
        FileLineIterator fileLineIterator = fileQueryDao.execute(inputFileName,
            resultClass.getClass());
        
        if (fileLineIterator == null) {
            return new CollectorResult(ReturnCode.NORMAL_END, collected);
        }
        
        try {
            while (fileLineIterator.hasNext()) {
                try {
                    // ̓t@C1s擾
                    Object fileLineObject = fileLineIterator.next();
                    
                    collectedDataHandler.handle(fileLineObject, collected++);
                  
                    // グ
                    jobStatus.incrementCollected();
                } catch (FileLineException ex) {
                    if (readNextLine) {
                        // Oo͌A̍sǂ
                        writeWarnLog(ex);
                        continue;
                    } else {
                        throw ex;
                    }
                }
            }
        } finally {
            fileLineIterator.closeFile();
        }
        
        // RN^[ʃIuWFNgԋp
        return new CollectorResult(ReturnCode.NORMAL_END, collected);
        
    }

    /**
     * t@CANZXpDAOݒ肷B
     *
     * @param fileQueryDao t@CANZXpDAO
     */
    public void setFileQueryDao(FileQueryDAO fileQueryDao) {
        this.fileQueryDao = fileQueryDao;
    }

    /**
     * ̓t@Cݒ肷B
     *
     * @param inputFileName ̓t@C
     */
    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    /**
     * ʃNXݒ肷B
     *
     * @param resultClass ʃNX
     */
    public void setResultClass(Object resultClass) {
        this.resultClass = resultClass;
    }
    
    /**
     * t@CsIteratoȑptOݒ肷B
     * 
     * @param readNextLine tO
     */
    public void setReadNextLine(boolean readNextLine) {
        this.readNextLine = readNextLine;
    }

    /**
     * sOꍇ̌xOo͂B
     * 
     * @param fileLineException t@CsO
     */
    protected void writeWarnLog(FileLineException fileLineException) {
        StringBuilder builder = new StringBuilder();
        builder.append(fileLineException.toString());
        builder.append(" : [FileName=");
        builder.append(fileLineException.getFileName());
        builder.append("] [LineNo=");
        builder.append(fileLineException.getLineNo());
        builder.append("] [ColumnName=");
        builder.append(fileLineException.getColumnName());
        builder.append("]");
        log.warn(builder.toString());
    }
    
}
